{{--
    Page Header Component - Modern Compact Design

    Usage:
    <x-layout.page-header title="Stock Items" icon="boxes" iconColor="success" />
    <x-layout.page-header title="Customer Registration" icon="user-plus" iconColor="primary" />
    <x-layout.page-header title="RFQ List" icon="file-alt" iconColor="info">
        <a href="{{ route('admin.rfq.rfq') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Add New
        </a>
    </x-layout.page-header>

    Props:
    - title: Page title (required) - can include prefix like "UEPL | Title"
    - icon: FontAwesome icon name without 'fa-' prefix (optional, default: 'file-alt')
    - iconColor: Bootstrap color name (primary, success, info, warning, danger) (optional, default: 'primary')
    - showDateTime: Show date/time display (optional, default: true)
--}}

@props([
    'title',
    'icon' => 'file-alt',
    'iconColor' => 'primary',
    'showDateTime' => true
])

<div class="page-header d-flex align-items-center justify-content-between flex-wrap">
    <h1>
        <i class="fas fa-{{ $icon }} mr-2 text-{{ $iconColor }}"></i>{{ $title }}
    </h1>

    <div class="d-flex align-items-center page-header-right">
        @if($slot->isNotEmpty())
        <div class="page-header-actions mr-3">
            {{ $slot }}
        </div>
        @endif

        @if($showDateTime)
        <div class="datetime-display d-flex align-items-center">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">day</span>,
                <span id="daynum">00</span>
                <span id="month">month</span>
                <span id="year">0000</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time">00:00:00</span>
            </div>
        </div>
        @endif
    </div>
</div>
