{{--
    Alert Component

    Usage:
    <x-layout.alert />  {{-- Auto-displays session flash messages --}}
    <x-layout.alert type="success" message="Item saved successfully!" />
    <x-layout.alert type="danger" message="An error occurred." :dismissible="true" />

    Props:
    - type: Alert type - success, danger, warning, info (optional, auto-detects from session)
    - message: Alert message (optional, auto-detects from session)
    - dismissible: Show close button (default: true)
--}}

@props([
    'type' => null,
    'message' => null,
    'dismissible' => true
])

@php
    // Auto-detect from session if not provided
    if (!$type && !$message) {
        if (session('success')) {
            $type = 'success';
            $message = session('success');
        } elseif (session('error')) {
            $type = 'danger';
            $message = session('error');
        } elseif (session('warning')) {
            $type = 'warning';
            $message = session('warning');
        } elseif (session('info')) {
            $type = 'info';
            $message = session('info');
        }
    }

    $icons = [
        'success' => 'check-circle',
        'danger' => 'exclamation-circle',
        'warning' => 'exclamation-triangle',
        'info' => 'info-circle'
    ];
@endphp

@if($message)
<div class="alert alert-{{ $type }} {{ $dismissible ? 'alert-dismissible fade show' : '' }}" role="alert">
    <i class="fas fa-{{ $icons[$type] ?? 'info-circle' }} mr-2"></i>
    {{ $message }}
    @if($dismissible)
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
    @endif
</div>
@endif

{{-- Display validation errors --}}
@if($errors->any())
<div class="alert alert-danger {{ $dismissible ? 'alert-dismissible fade show' : '' }}" role="alert">
    <i class="fas fa-exclamation-circle mr-2"></i>
    <strong>Please fix the following errors:</strong>
    <ul class="mb-0 mt-2">
        @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
    @if($dismissible)
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
    @endif
</div>
@endif
