{{--
    Form Group Component

    Usage:
    <x-forms.form-group label="Email" name="email" type="email" required />
    <x-forms.form-group label="Description" name="description" type="textarea" rows="4" />
    <x-forms.form-group label="Price" name="price" type="number" step="0.01" prefix="$" />

    Props:
    - label: Field label (required)
    - name: Input name attribute (required)
    - type: Input type - text, email, number, tel, date, textarea, password (default: text)
    - value: Default value (optional)
    - placeholder: Placeholder text (optional)
    - required: Is field required (default: false)
    - disabled: Is field disabled (default: false)
    - readonly: Is field readonly (default: false)
    - prefix: Input prefix text (optional)
    - suffix: Input suffix text (optional)
    - help: Help text below input (optional)
    - rows: Rows for textarea (default: 3)
    - step: Step for number input (optional)
    - min: Min value for number input (optional)
    - max: Max value for number input (optional)
    - col: Bootstrap column class (default: col-md-6)
--}}

@props([
    'label',
    'name',
    'type' => 'text',
    'value' => null,
    'placeholder' => null,
    'required' => false,
    'disabled' => false,
    'readonly' => false,
    'prefix' => null,
    'suffix' => null,
    'help' => null,
    'rows' => 3,
    'step' => null,
    'min' => null,
    'max' => null,
    'col' => 'col-md-6'
])

@php
    $inputId = $name . '_' . uniqid();
    $oldValue = old($name, $value);
    $hasError = $errors->has($name);
@endphp

<div class="{{ $col }} mb-3">
    <label for="{{ $inputId }}" class="form-label">
        {{ $label }}
        @if($required)
        <span class="text-danger">*</span>
        @endif
    </label>

    @if($prefix || $suffix)
    <div class="input-group">
        @if($prefix)
        <div class="input-group-prepend">
            <span class="input-group-text">{{ $prefix }}</span>
        </div>
        @endif
    @endif

    @if($type === 'textarea')
        <textarea
            id="{{ $inputId }}"
            name="{{ $name }}"
            class="form-control {{ $hasError ? 'is-invalid' : '' }}"
            rows="{{ $rows }}"
            placeholder="{{ $placeholder }}"
            {{ $required ? 'required' : '' }}
            {{ $disabled ? 'disabled' : '' }}
            {{ $readonly ? 'readonly' : '' }}
            {{ $attributes }}
        >{{ $oldValue }}</textarea>
    @else
        <input
            type="{{ $type }}"
            id="{{ $inputId }}"
            name="{{ $name }}"
            class="form-control {{ $hasError ? 'is-invalid' : '' }}"
            value="{{ $oldValue }}"
            placeholder="{{ $placeholder }}"
            {{ $required ? 'required' : '' }}
            {{ $disabled ? 'disabled' : '' }}
            {{ $readonly ? 'readonly' : '' }}
            @if($step) step="{{ $step }}" @endif
            @if($min !== null) min="{{ $min }}" @endif
            @if($max !== null) max="{{ $max }}" @endif
            {{ $attributes }}
        >
    @endif

    @if($prefix || $suffix)
        @if($suffix)
        <div class="input-group-append">
            <span class="input-group-text">{{ $suffix }}</span>
        </div>
        @endif
    </div>
    @endif

    @if($hasError)
    <div class="invalid-feedback d-block">
        {{ $errors->first($name) }}
    </div>
    @endif

    @if($help)
    <small class="form-text text-muted">{{ $help }}</small>
    @endif
</div>
