{{--
    Date Picker Component

    Usage:
    <x-forms.date-picker label="Start Date" name="start_date" required />
    <x-forms.date-picker label="End Date" name="end_date" :value="$endDate" />

    Props:
    - label: Field label (required)
    - name: Input name attribute (required)
    - value: Default value (optional)
    - placeholder: Placeholder text (default: 'YYYY-MM-DD')
    - required: Is field required (default: false)
    - disabled: Is field disabled (default: false)
    - min: Minimum date (optional)
    - max: Maximum date (optional)
    - col: Bootstrap column class (default: col-md-6)
    - help: Help text below input (optional)
--}}

@props([
    'label',
    'name',
    'value' => null,
    'placeholder' => 'YYYY-MM-DD',
    'required' => false,
    'disabled' => false,
    'min' => null,
    'max' => null,
    'col' => 'col-md-6',
    'help' => null
])

@php
    $inputId = $name . '_' . uniqid();
    $oldValue = old($name, $value);
    $hasError = $errors->has($name);

    // Format date if it's a Carbon instance
    if ($oldValue instanceof \Carbon\Carbon) {
        $oldValue = $oldValue->format('Y-m-d');
    }
@endphp

<div class="{{ $col }} mb-3">
    <label for="{{ $inputId }}" class="form-label">
        {{ $label }}
        @if($required)
        <span class="text-danger">*</span>
        @endif
    </label>

    <div class="input-group">
        <div class="input-group-prepend">
            <span class="input-group-text">
                <i class="fas fa-calendar-alt"></i>
            </span>
        </div>
        <input
            type="date"
            id="{{ $inputId }}"
            name="{{ $name }}"
            class="form-control {{ $hasError ? 'is-invalid' : '' }}"
            value="{{ $oldValue }}"
            placeholder="{{ $placeholder }}"
            {{ $required ? 'required' : '' }}
            {{ $disabled ? 'disabled' : '' }}
            @if($min) min="{{ $min }}" @endif
            @if($max) max="{{ $max }}" @endif
            {{ $attributes }}
        >
    </div>

    @if($hasError)
    <div class="invalid-feedback d-block">
        {{ $errors->first($name) }}
    </div>
    @endif

    @if($help)
    <small class="form-text text-muted">{{ $help }}</small>
    @endif
</div>
