@extends('layouts.dashboard.adminapp')

@section('title', 'Machine Report')

@section('styles')
<style>
    .stat-card { border-radius: 10px; padding: 20px; text-align: center; color: #fff; transition: transform 0.2s; }
    .stat-card:hover { transform: translateY(-3px); }
    .stat-card .stat-value { font-size: 1.8rem; font-weight: bold; }
    .stat-card .stat-label { font-size: 0.85rem; opacity: 0.9; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Machine Report</h1>
</div>

<!-- Filter Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-filter mr-2"></i>Filters</h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('admin.report.machinereport') }}">
            <div class="row align-items-end">
                <div class="col-md-4 mb-3">
                    <label class="small font-weight-bold">Machine</label>
                    <select class="form-control form-control-sm" name="machine_id">
                        <option value="">All Machines</option>
                        @foreach($machineNames as $id => $name)
                            <option value="{{ $id }}" {{ $selectedMachine == $id ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <button type="submit" class="btn btn-primary btn-sm"><i class="fas fa-search mr-1"></i>Filter</button>
                    <a href="{{ route('admin.report.machinereport') }}" class="btn btn-secondary btn-sm"><i class="fas fa-undo mr-1"></i>Reset</a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Stats -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
            <div class="stat-value">{{ $machines->count() }}</div>
            <div class="stat-label">Total Machines</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
            <div class="stat-value">{{ $machines->sum(fn($m) => $m->routeProcesses->count()) }}</div>
            <div class="stat-label">Total Processes</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
            <div class="stat-value">{{ $machineLogs->count() }}</div>
            <div class="stat-label">Log Entries</div>
        </div>
    </div>
</div>

<!-- Machine Utilization Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-cogs mr-2"></i>Machine Utilization</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="machineTable" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>Machine ID</th>
                        <th>Machine Name</th>
                        <th>Process Count</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($machines as $machine)
                        <tr>
                            <td>{{ $machine->machine_id }}</td>
                            <td>{{ $machine->machine_name }}</td>
                            <td>{{ $machine->routeProcesses->count() }}</td>
                            <td><span class="badge badge-{{ $machine->status == 'active' ? 'success' : 'secondary' }}">{{ ucfirst($machine->status ?? 'Active') }}</span></td>
                        </tr>
                    @empty
                        <tr><td colspan="4" class="text-center text-muted">No machines found</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Machine Logs Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-clipboard-list mr-2"></i>Machine Logs</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="logsTable" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>Date</th>
                        <th>Machine</th>
                        <th>Log Type</th>
                        <th>Description</th>
                        <th>Reported By</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($machineLogs as $log)
                        <tr>
                            <td>{{ $log->created_at ? $log->created_at->format('d-m-Y H:i') : '-' }}</td>
                            <td>{{ $log->machine->machine_name ?? '-' }}</td>
                            <td><span class="badge badge-{{ $log->log_type == 'breakdown' ? 'danger' : 'info' }}">{{ ucfirst($log->log_type ?? 'Info') }}</span></td>
                            <td>{{ Str::limit($log->description, 50) }}</td>
                            <td>{{ $log->reporter->name ?? '-' }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="text-center text-muted">No logs found</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('#machineTable').DataTable({ dom: 'Bfrtip', buttons: ['copy', 'csv', 'excel', 'pdf', 'print'], pageLength: 25 });
    $('#logsTable').DataTable({ dom: 'Bfrtip', buttons: ['copy', 'csv', 'excel', 'pdf', 'print'], order: [[0, 'desc']], pageLength: 25 });
});
</script>
@endsection
