@extends('layouts.dashboard.adminapp')

@section('title', 'Inventory Report')

@section('styles')
<style>
    .stat-card { border-radius: 10px; padding: 20px; text-align: center; color: #fff; transition: transform 0.2s; }
    .stat-card:hover { transform: translateY(-3px); }
    .stat-card .stat-value { font-size: 1.8rem; font-weight: bold; }
    .stat-card .stat-label { font-size: 0.85rem; opacity: 0.9; }
    .positive { color: #1cc88a; font-weight: bold; }
    .negative { color: #e74a3b; font-weight: bold; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Inventory Report</h1>
</div>

<!-- Filter Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-filter mr-2"></i>Filters</h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('admin.report.inventoryreport') }}">
            <div class="row align-items-end">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Material</label>
                    <select class="form-control form-control-sm" name="material_code">
                        <option value="">All Materials</option>
                        @foreach($materialOptions as $code => $label)
                            <option value="{{ $code }}" {{ $selectedMaterial == $code ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">From Date</label>
                    <input type="date" class="form-control form-control-sm" name="from_date" value="{{ $fromDate }}">
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">To Date</label>
                    <input type="date" class="form-control form-control-sm" name="to_date" value="{{ $toDate }}">
                </div>
                <div class="col-md-3 mb-3">
                    <button type="submit" class="btn btn-primary btn-sm"><i class="fas fa-search mr-1"></i>Filter</button>
                    <a href="{{ route('admin.report.inventoryreport') }}" class="btn btn-secondary btn-sm"><i class="fas fa-undo mr-1"></i>Reset</a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Stats -->
@php
    $totalPurchased = collect($inventory)->sum('purchased');
    $totalSold = collect($inventory)->sum('sold');
    $totalBalance = collect($inventory)->sum('balance');
@endphp
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
            <div class="stat-value">{{ count($inventory) }}</div>
            <div class="stat-label">Total Materials</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
            <div class="stat-value">{{ number_format($totalPurchased) }}</div>
            <div class="stat-label">Total Purchased</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);">
            <div class="stat-value">{{ number_format($totalSold) }}</div>
            <div class="stat-label">Total Sold</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
            <div class="stat-value">{{ number_format($totalBalance) }}</div>
            <div class="stat-label">Current Balance</div>
        </div>
    </div>
</div>

<!-- Report Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-boxes mr-2"></i>Inventory Report</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="inventoryTable" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>Material Code</th>
                        <th>Description</th>
                        <th>Purchased</th>
                        <th>Sold</th>
                        <th>Balance</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($inventory as $item)
                        <tr>
                            <td>{{ $item['material_code'] }}</td>
                            <td>{{ $item['description'] }}</td>
                            <td class="text-right positive">+{{ number_format($item['purchased']) }}</td>
                            <td class="text-right negative">-{{ number_format($item['sold']) }}</td>
                            <td class="text-right font-weight-bold {{ $item['balance'] >= 0 ? 'positive' : 'negative' }}">
                                {{ number_format($item['balance']) }}
                            </td>
                            <td>
                                @if($item['balance'] <= 0)
                                    <span class="badge badge-danger">Out of Stock</span>
                                @elseif($item['balance'] < 10)
                                    <span class="badge badge-warning">Low Stock</span>
                                @else
                                    <span class="badge badge-success">In Stock</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="text-center text-muted">No inventory records found</td></tr>
                    @endforelse
                </tbody>
                <tfoot class="bg-light">
                    <tr class="font-weight-bold">
                        <td colspan="2" class="text-right">TOTAL:</td>
                        <td class="text-right positive">+{{ number_format($totalPurchased) }}</td>
                        <td class="text-right negative">-{{ number_format($totalSold) }}</td>
                        <td class="text-right {{ $totalBalance >= 0 ? 'positive' : 'negative' }}">{{ number_format($totalBalance) }}</td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('#inventoryTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        order: [[0, 'asc']],
        pageLength: 25
    });
});
</script>
@endsection
