@extends('layouts.dashboard.adminapp')

@section('title', 'Employee Report')

@section('styles')
<style>
    div.dt-buttons { float: left; display: flex !important; }
    .dataTable { overflow-x: auto !important; display: table !important; }
    .dt-buttons .btn { margin-right: 0.5rem !important; padding: 0.25rem 0.75rem !important; font-size: 0.95rem !important; }
    .nav-tabs .nav-link { font-weight: 600; color: #5a5c69; border: none; padding: 12px 24px; border-radius: 8px 8px 0 0; margin-right: 4px; background: #f8f9fc; transition: all 0.2s; }
    .nav-tabs .nav-link:hover { background: #eaecf4; color: #4e73df; }
    .nav-tabs .nav-link.active { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); color: #fff; border: none; }
    .stat-card { border-radius: 10px; padding: 20px; text-align: center; color: #fff; transition: transform 0.2s; }
    .stat-card:hover { transform: translateY(-3px); }
    .stat-card .stat-value { font-size: 1.8rem; font-weight: bold; }
    .stat-card .stat-label { font-size: 0.85rem; opacity: 0.9; }
    .bg-total { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-present { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-leave { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .bg-absent { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Employee Report</h1>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
    </div>
@endif

<!-- Filter Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-filter mr-2"></i>Filters</h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('admin.report.employeereport') }}" id="filterForm">
            <div class="row align-items-end">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Employee</label>
                    <select class="form-control form-control-sm" name="employee_id">
                        <option value="">All Employees</option>
                        @foreach($employees as $emp)
                            <option value="{{ $emp->id }}" {{ $employeeId == $emp->id ? 'selected' : '' }}>
                                {{ $emp->employee_id }} - {{ $emp->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">From Date</label>
                    <input type="date" class="form-control form-control-sm" name="from_date" value="{{ $fromDate }}">
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">To Date</label>
                    <input type="date" class="form-control form-control-sm" name="to_date" value="{{ $toDate }}">
                </div>
                <div class="col-md-2 mb-3">
                    <input type="hidden" name="tab" value="{{ $tab }}">
                    <button type="submit" class="btn btn-primary btn-sm"><i class="fas fa-search mr-1"></i>Filter</button>
                    <a href="{{ route('admin.report.employeereport') }}" class="btn btn-secondary btn-sm"><i class="fas fa-undo mr-1"></i>Reset</a>
                </div>
                <div class="col-md-3 mb-3 text-right">
                    <a href="{{ route('admin.report.employeereport.export', request()->query()) }}" class="btn btn-success btn-sm">
                        <i class="fas fa-file-excel mr-1"></i>Export Excel
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Tabs -->
<ul class="nav nav-tabs mb-3">
    <li class="nav-item">
        <a class="nav-link {{ $tab == 'attendance' ? 'active' : '' }}" href="{{ route('admin.report.employeereport', ['tab' => 'attendance'] + request()->except('tab')) }}">
            <i class="fas fa-calendar-check mr-1"></i>Attendance Report
        </a>
    </li>
    <li class="nav-item">
        <a class="nav-link {{ $tab == 'leave' ? 'active' : '' }}" href="{{ route('admin.report.employeereport', ['tab' => 'leave'] + request()->except('tab')) }}">
            <i class="fas fa-calendar-times mr-1"></i>Leave Report
        </a>
    </li>
</ul>

<!-- Report Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-table mr-2"></i>{{ $tab == 'attendance' ? 'Attendance' : 'Leave' }} Report
        </h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            @if($tab == 'attendance')
                <table class="table table-bordered table-striped" id="reportTable" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>Date</th>
                            <th>Employee</th>
                            <th>Shift</th>
                            <th>First Half</th>
                            <th>Second Half</th>
                            <th>Late In</th>
                            <th>Early Out</th>
                            <th>Work Hours</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($attendanceReports as $report)
                            <tr>
                                <td>{{ $report->date }}</td>
                                <td>{{ $report->employeeDetails->name ?? '-' }}</td>
                                <td>{{ $report->shift ?? '-' }}</td>
                                <td><span class="badge badge-{{ $report->first_half == 'Present' ? 'success' : 'warning' }}">{{ $report->first_half }}</span></td>
                                <td><span class="badge badge-{{ $report->second_half == 'Present' ? 'success' : 'warning' }}">{{ $report->second_half }}</span></td>
                                <td>{{ $report->late_in ?? 0 }} min</td>
                                <td>{{ $report->early_out ?? 0 }} min</td>
                                <td>{{ $report->work_hours ?? 0 }} hrs</td>
                            </tr>
                        @empty
                            <tr><td colspan="8" class="text-center text-muted">No attendance records found</td></tr>
                        @endforelse
                    </tbody>
                </table>
            @else
                <table class="table table-bordered table-striped" id="reportTable" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>Employee</th>
                            <th>Leave Type</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Days</th>
                            <th>Reason</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($leaveReports as $leave)
                            <tr>
                                <td>{{ $leave->employee->name ?? '-' }}</td>
                                <td><span class="badge badge-info">{{ $leave->leave_type }}</span></td>
                                <td>{{ $leave->leave_from ? \Carbon\Carbon::parse($leave->leave_from)->format('d-m-Y') : '-' }}</td>
                                <td>{{ $leave->leave_to ? \Carbon\Carbon::parse($leave->leave_to)->format('d-m-Y') : '-' }}</td>
                                <td>{{ $leave->number_of_days }}</td>
                                <td>{{ Str::limit($leave->reason, 50) }}</td>
                                <td>
                                    @switch($leave->status)
                                        @case('Pending') <span class="badge badge-warning">Pending</span> @break
                                        @case('Approved') <span class="badge badge-success">Approved</span> @break
                                        @case('Rejected') <span class="badge badge-danger">Rejected</span> @break
                                        @default <span class="badge badge-secondary">{{ $leave->status }}</span>
                                    @endswitch
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="7" class="text-center text-muted">No leave records found</td></tr>
                        @endforelse
                    </tbody>
                </table>
            @endif
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('#reportTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        order: [[0, 'desc']],
        pageLength: 25
    });
});
</script>
@endsection
