@extends('layouts.dashboard.adminapp')

@section('title', 'Customer/Vendor Report')

@section('styles')
<style>
    .stat-card { border-radius: 10px; padding: 20px; text-align: center; color: #fff; transition: transform 0.2s; }
    .stat-card:hover { transform: translateY(-3px); }
    .stat-card .stat-value { font-size: 1.8rem; font-weight: bold; }
    .stat-card .stat-label { font-size: 0.85rem; opacity: 0.9; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Customer/Vendor Report</h1>
</div>

<!-- Filter Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-filter mr-2"></i>Filters</h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('admin.report.customerreport') }}">
            <div class="row align-items-end">
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">Role</label>
                    <select class="form-control form-control-sm" name="company_role">
                        <option value="">All Roles</option>
                        <option value="customer" {{ request('company_role') == 'customer' ? 'selected' : '' }}>Customer</option>
                        <option value="vendor" {{ request('company_role') == 'vendor' ? 'selected' : '' }}>Vendor</option>
                        <option value="both" {{ request('company_role') == 'both' ? 'selected' : '' }}>Both</option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Company</label>
                    <select class="form-control form-control-sm" name="company">
                        <option value="">All Companies</option>
                        @foreach($companyNames as $name)
                            <option value="{{ $name }}" {{ request('company') == $name ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">From Date</label>
                    <input type="date" class="form-control form-control-sm" name="from_date" value="{{ request('from_date') }}">
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">To Date</label>
                    <input type="date" class="form-control form-control-sm" name="to_date" value="{{ request('to_date') }}">
                </div>
                <div class="col-md-3 mb-3">
                    <button type="submit" class="btn btn-primary btn-sm"><i class="fas fa-search mr-1"></i>Filter</button>
                    <a href="{{ route('admin.report.customerreport') }}" class="btn btn-secondary btn-sm"><i class="fas fa-undo mr-1"></i>Reset</a>
                    <a href="{{ route('admin.report.customerreport.export', request()->query()) }}" class="btn btn-success btn-sm">
                        <i class="fas fa-file-excel mr-1"></i>Export
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Stats -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
            <div class="stat-value">{{ $customers->count() }}</div>
            <div class="stat-label">Total Records</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
            <div class="stat-value">{{ $customers->where('company_role', 'customer')->count() }}</div>
            <div class="stat-label">Customers</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
            <div class="stat-value">{{ $customers->where('company_role', 'vendor')->count() }}</div>
            <div class="stat-label">Vendors</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
            <div class="stat-value">{{ $customers->where('status', 'active')->count() }}</div>
            <div class="stat-label">Active</div>
        </div>
    </div>
</div>

<!-- Report Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-table mr-2"></i>Customer/Vendor Report</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="customerTable" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>Role</th>
                        <th>Company</th>
                        <th>Email</th>
                        <th>Mobile</th>
                        <th>GST No</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Created</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($customers as $customer)
                        <tr>
                            <td><span class="badge badge-{{ $customer->company_role == 'customer' ? 'primary' : ($customer->company_role == 'vendor' ? 'info' : 'warning') }}">{{ ucfirst($customer->company_role) }}</span></td>
                            <td>{{ $customer->company }}</td>
                            <td>{{ $customer->email ?? '-' }}</td>
                            <td>{{ $customer->mobile ?? '-' }}</td>
                            <td>{{ $customer->gstno ?? '-' }}</td>
                            <td>{{ $customer->company_type ?? '-' }}</td>
                            <td><span class="badge badge-{{ $customer->status == 'active' ? 'success' : 'secondary' }}">{{ ucfirst($customer->status ?? 'N/A') }}</span></td>
                            <td>{{ $customer->created_at ? $customer->created_at->format('d-m-Y') : '-' }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="8" class="text-center text-muted">No records found</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('#customerTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        order: [[1, 'asc']],
        pageLength: 25
    });
});
</script>
@endsection
