@extends('layouts.dashboard.adminapp')

@section('title', 'Bill/Invoice Report')

@section('styles')
<style>
    .stat-card { border-radius: 10px; padding: 20px; text-align: center; color: #fff; transition: transform 0.2s; }
    .stat-card:hover { transform: translateY(-3px); }
    .stat-card .stat-value { font-size: 1.8rem; font-weight: bold; }
    .stat-card .stat-label { font-size: 0.85rem; opacity: 0.9; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Bill/Invoice Report</h1>
</div>

<!-- Filter Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-filter mr-2"></i>Filters</h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('admin.report.billreport') }}">
            <div class="row align-items-end">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Company</label>
                    <select class="form-control form-control-sm" name="company_id">
                        <option value="">All Companies</option>
                        @foreach($companies as $id => $name)
                            <option value="{{ $id }}" {{ $selectedCompany == $id ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">From Date</label>
                    <input type="date" class="form-control form-control-sm" name="from_date" value="{{ $fromDate }}">
                </div>
                <div class="col-md-2 mb-3">
                    <label class="small font-weight-bold">To Date</label>
                    <input type="date" class="form-control form-control-sm" name="to_date" value="{{ $toDate }}">
                </div>
                <div class="col-md-3 mb-3">
                    <button type="submit" class="btn btn-primary btn-sm"><i class="fas fa-search mr-1"></i>Filter</button>
                    <a href="{{ route('admin.report.billreport') }}" class="btn btn-secondary btn-sm"><i class="fas fa-undo mr-1"></i>Reset</a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Stats -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
            <div class="stat-value">{{ $invoices->count() }}</div>
            <div class="stat-label">Total Invoices</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
            <div class="stat-value">{{ number_format($invoices->sum('total_amount'), 2) }}</div>
            <div class="stat-label">Total Amount</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
            <div class="stat-value">{{ number_format($invoices->sum('taxable_value'), 2) }}</div>
            <div class="stat-label">Taxable Value</div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stat-card" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
            <div class="stat-value">{{ number_format($invoices->sum('sgst') + $invoices->sum('cgst') + $invoices->sum('igst'), 2) }}</div>
            <div class="stat-label">Total Tax</div>
        </div>
    </div>
</div>

<!-- Report Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-file-invoice mr-2"></i>Invoice Report</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="billTable" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>Invoice No</th>
                        <th>Date</th>
                        <th>Company</th>
                        <th>Taxable Value</th>
                        <th>SGST</th>
                        <th>CGST</th>
                        <th>IGST</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $invoice)
                        <tr>
                            <td>{{ $invoice->invoice_no }}</td>
                            <td>{{ $invoice->invoice_date ? \Carbon\Carbon::parse($invoice->invoice_date)->format('d-m-Y') : '-' }}</td>
                            <td>{{ $invoice->company->company ?? '-' }}</td>
                            <td class="text-right">{{ number_format($invoice->taxable_value, 2) }}</td>
                            <td class="text-right">{{ number_format($invoice->sgst, 2) }}</td>
                            <td class="text-right">{{ number_format($invoice->cgst, 2) }}</td>
                            <td class="text-right">{{ number_format($invoice->igst, 2) }}</td>
                            <td class="text-right font-weight-bold">{{ number_format($invoice->total_amount, 2) }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="8" class="text-center text-muted">No invoices found</td></tr>
                    @endforelse
                </tbody>
                <tfoot class="bg-light">
                    <tr class="font-weight-bold">
                        <td colspan="3" class="text-right">TOTAL:</td>
                        <td class="text-right">{{ number_format($invoices->sum('taxable_value'), 2) }}</td>
                        <td class="text-right">{{ number_format($invoices->sum('sgst'), 2) }}</td>
                        <td class="text-right">{{ number_format($invoices->sum('cgst'), 2) }}</td>
                        <td class="text-right">{{ number_format($invoices->sum('igst'), 2) }}</td>
                        <td class="text-right">{{ number_format($invoices->sum('total_amount'), 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('#billTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        order: [[1, 'desc']],
        pageLength: 25
    });
});
</script>
@endsection
