@extends('layouts.dashboard.adminapp')

@section('title', 'Manage Stock Items')

<style>
    .btn {
        width: auto;
    }
    /* Put length and filter on the same line */
    div.dataTables_wrapper div.dataTables_length,
    div.dataTables_wrapper div.dataTables_filter {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
    }

    /* Align them side by side */
    div.dataTables_wrapper div.dataTables_length {
        float: left;
    }

    div.dataTables_wrapper div.dataTables_filter {
        float: right;
    }

    /* Optional: Style inputs and selects */
    div.dataTables_wrapper .dataTables_filter input {
        margin-left: 0.5rem;
    }

    div.dataTables_wrapper .dataTables_length select {
        margin: 0 0.5rem;
    }
</style>

@section('content')
<div class="container-fluid">
    <x-layout.page-header title="UEPL / Stock Items" icon="database" iconColor="secondary" />

    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center gap-3">
            <span class="fw-bold">Manage Items</span>
            <!-- Action buttons -->
            <div style="float: right;">
                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#categoryModal">Add Category</button>
                <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#itemModal">Add Item</button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover text-dark w-100" id="stockItemsTable">
                    <thead class="table-light">
                        <tr class="text-center align-middle">
                            <th>ID</th>
                            <th>Item</th>
                            <th>Category</th>
                            <th>UOM</th>
                            <th>SGST</th>
                            <th>CGST</th>
                            <th>IGST</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($stockItems as $item)
                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>{{ $item->item_name }}</td>
                                <td>{{ $item->category->name }}</td>
                                <td>{{ $item->uom }}</td>
                                <td>{{ $item->sgst }}</td>
                                <td>{{ $item->cgst }}</td>
                                <td>{{ $item->igst }}</td>
                                <td>
                                    <button 
                                        class="btn btn-warning btn-sm editItemBtn"
                                        data-id="{{ $item->id }}"
                                        data-item_name="{{ $item->item_name }}"
                                        data-category_id="{{ $item->category_id }}"
                                        data-uom="{{ $item->uom }}"
                                        data-sgst="{{ $item->sgst }}"
                                        data-cgst="{{ $item->cgst }}"
                                        data-igst="{{ $item->igst }}"
                                        data-bs-toggle="modal" 
                                        data-bs-target="#editItemModal"
                                    >
                                        Edit
                                    </button>

                                    <form action="{{ route('admin.stockitems.destroy', $item->id) }}" method="POST" style="display:inline;">
                                        @csrf 
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Delete this item?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- CATEGORY MODAL -->
    <div class="modal fade" id="categoryModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="{{ route('admin.categories.store') }}" method="POST" class="modal-content">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Add Category</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <label for="categoryName">Category Name</label>
                    <input type="text" name="name" id="categoryName" class="form-control" required>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save Category</button>
                </div>
            </form>
        </div>
    </div>

    <!-- ADD ITEM MODAL -->
    <div class="modal fade" id="itemModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="{{ route('admin.stockitems.store') }}" method="POST" class="modal-content">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Add Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <label>Category</label>
                    <select name="category_id" class="form-control" required>
                        @foreach($categories as $cat)
                            <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                        @endforeach
                    </select>

                    <label class="mt-2">Item Name</label>
                    <input type="text" name="item_name" class="form-control" required>

                    <label class="mt-2">UOM</label>
                    <input type="text" name="uom" class="form-control">

                    <label class="mt-2">SGST</label>
                    <input type="number" step="1" name="sgst" class="form-control">

                    <label class="mt-2">CGST</label>
                    <input type="number" step="1" name="cgst" class="form-control">

                    <label class="mt-2">IGST</label>
                    <input type="number" step="1" name="igst" class="form-control">
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Save Item</button>
                </div>
            </form>
        </div>
    </div>

    <!-- EDIT ITEM MODAL -->
    <div class="modal fade" id="editItemModal" tabindex="-1">
        <div class="modal-dialog">
            <form method="POST" id="editItemForm" class="modal-content">
                @csrf
                @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title">Edit Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="item_id" id="edit_item_id">

                    <label>Category</label>
                    <select name="category_id" id="edit_category_id" class="form-control" required>
                        @foreach($categories as $cat)
                            <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                        @endforeach
                    </select>

                    <label class="mt-2">Item Name</label>
                    <input type="text" name="item_name" id="edit_item_name" class="form-control" required>

                    <label class="mt-2">UOM</label>
                    <input type="text" name="uom" id="edit_uom" class="form-control">

                    <label class="mt-2">SGST</label>
                    <input type="number" step="0.01" name="sgst" id="edit_sgst" class="form-control">

                    <label class="mt-2">CGST</label>
                    <input type="number" step="0.01" name="cgst" id="edit_cgst" class="form-control">

                    <label class="mt-2">IGST</label>
                    <input type="number" step="0.01" name="igst" id="edit_igst" class="form-control">
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update Item</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <script>
        $(document).ready(function () {
            $('#stockItemsTable').DataTable();  

            // Populate the edit modal
            $('.editItemBtn').on('click', function () {
                const id = $(this).data('id');
                $('#editItemForm').attr('action', `/admin/stockitems/${id}`);
                $('#edit_item_name').val($(this).data('item_name'));
                $('#edit_category_id').val($(this).data('category_id'));
                $('#edit_uom').val($(this).data('uom'));
                $('#edit_sgst').val($(this).data('sgst'));
                $('#edit_cgst').val($(this).data('cgst'));
                $('#edit_igst').val($(this).data('igst'));
            });
        });
    </script>
@endpush
