@extends('layouts.dashboard.adminapp')

@section('title', 'Manufacturing Planning')

@section('content')

<!-- Page Heading -->
<x-layout.page-header title="UEPL / Manufacturing Planning" icon="tasks" iconColor="warning" />
                    <div class="mp-btn-board">
                        <button class="mp-add-task-board">New Job</button>
                    </div><br>
                    <!-- Content Row -->
                    <div id="manufacturing-planning" class="manufacturing-bg">
                        <div class="board"></div>
                        <!-- New Task Popup -->
                        <div class="mp-popup" id="new-task">
                            <div class="mp-popup-content">
                                <div class="mp-d-flex heading">
                                    <h4>New Process Details</h4>
                                    <span class="mp-close">✖</span>
                                </div>
                                <form id="add-task">
                                    <!-- <label for="task-title">Task Name</label>
                                    <input type="text" name="title" id="task-title" autocomplete="off" placeholder="Task title" required> -->

                                    <!-- Process Select Field -->
                                    <label for="process">Process <span class="required" title="required">*</span></label>
                                    <select id="processSelect" required>
                                        <option value="">Select Process</option>
                                        <option value="Process A">Process A</option>
                                        <option value="Process B">Process B</option>
                                        <option value="Process C">Process C</option>
                                    </select>

                                    <!-- Machine Select Field -->
                                    <label for="machine-name">Machine <span class="required" title="required">*</span></label>
                                    <select id="machineNameSelect" required>
                                        <option value="">Select Machine</option>
                                        <!-- <option value="Machine 1">Machine 1</option>
                                        <option value="Machine 2">Machine 2</option>
                                        <option value="Machine 3">Machine 3</option> -->
                                    </select>
                                    <!-- Operator Select Field -->
                                    <label for="operator">Operator</label>
                                    <select id="operatorSelect">
                                        <option value="">Select Operator</option>
                                        <option value="Operator A">Operator A</option>
                                        <option value="Operator B">Operator B</option>
                                        <option value="Operator C">Operator C</option>
                                    </select>
                                    <div class="row">
                                        <!-- Start Date Field -->
                                        <!-- <label for="cycleTime">Cycle Time</label>
                                        <input type="time" id="cycleTime" required> -->
                                        <div class="col-md-6">
                                            <!-- Start Cycle Time -->
                                            <label for="hours">Cycle Time (Hours) <span class="required" title="required">*</span></label>
                                            <input type="number" id="ctHours" min="0" required placeholder="Hours">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="minutes">Cycle Time (Minutes) <span class="required" title="required">*</span></label>
                                            <input type="number" id="ctMinutes" min="0" max="59" required placeholder="Minutes">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <!-- Start Date Field -->
                                            <label for="startTimer">Start Date</label>
                                            <input type="datetime-local" id="startTime">
                                        </div>
                                        <div class="col-md-6">
                                            <!-- End Date Field -->
                                            <label for="endTimer">End Date</label>
                                            <input type="datetime-local" id="endTime">
                                        </div>
                                    </div>

                                    <label for="task-desc">Description</label>
                                    <textarea name="desc" id="task-desc" cols="30" rows="4" placeholder="Task description"></textarea>
                                    <label for="task-priority">Priority</label>
                                    <select name="priority" id="task-priority">
                                        <option value="low">Low</option>
                                        <option value="medium">Medium</option>
                                        <option value="high">High</option>
                                    </select>
                                </form>
                                <div class="footer">
                                    <button type="submit" class="col-md-3 btn-success" id="bt-task">Add</button>
                                    <button type="button" class="col-md-3 btn-danger mp-close">Cancel</button>
                                </div>
                            </div>
                        </div>
            
                        <!-- Edit Task Popup -->
                        <div class="mp-popup" id="edit-task">
                            <div class="mp-popup-content">
                                <div class="mp-d-flex heading">
                                    <h4>Edit Process Details</h4>
                                    <span class="mp-close">✖</span>
                                </div>
                                <form id="editfrm-task">
                                    <label for="edit-process">Process <span class="required" title="required">*</span></label>
                                    <select id="edit-process" required>
                                        <option value="">Select Process</option>
                                        <option value="Process A">Process A</option>
                                        <option value="Process B">Process B</option>
                                        <option value="Process C">Process C</option>
                                    </select>
                                    
                                    <label for="edit-machine-name">Machine <span class="required" title="required">*</span></label>
                                    <select id="edit-machine-name" required>
                                        <option value="">Select Machine</option>
                                        <!-- <option value="Machine 1">Machine 1</option>
                                        <option value="Machine 2">Machine 2</option>
                                        <option value="Machine 3">Machine 3</option> -->
                                    </select>
                                    
                                    <!-- Operator Select Field -->
                                    <label for="editOperator">Operator</label>
                                    <select id="editOperatorSelect">
                                        <option value="">Select Operator</option>
                                        <option value="Operator A">Operator A</option>
                                        <option value="Operator B">Operator B</option>
                                        <option value="Operator C">Operator C</option>
                                    </select>
                                    <div class="row">
                                        <!-- Start Date Field -->
                                        <!-- <label for="cycleTime">Cycle Time</label>
                                        <input type="time" id="cycleTime" required> -->
                                        <div class="col-md-6">
                                            <!-- Start Cycle Time -->
                                            <label for="hours">Cycle Time (Hours) <span class="required" title="required">*</span></label>
                                            <input type="number" id="editctHours" min="0" required placeholder="Hours">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="minutes">Cycle Time (Minutes) <span class="required" title="required">*</span></label>
                                            <input type="number" id="editctMinutes" min="0" max="59" required placeholder="Minutes">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label for="edit-start-time">Start Date</label>
                                            <input type="datetime-local" id="edit-start-time">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="edit-end-time">End Date</label>
                                            <input type="datetime-local" id="edit-end-time" readonly>
                                        </div>
                                    </div>
                                    <label for="edit-task-desc">Description</label>
                                    <textarea name="desc" id="edit-task-desc" cols="30" rows="4" placeholder="Task description"></textarea>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label for="edit-task-status">Status <span class="required" title="required">*</span></label>
                                            <select name="task-status-indicator" id="edit-task-status" required>
                                                <option value="Assigned">Assigned</option>
                                                <option value="Inprogress">Inprogress</option>
                                                <option value="Work Done">Work Done</option>
                                                <option value="Approved">Approved</option>
                                                <option value="Cancelled">Cancelled</option>
                                                <option value="Hold">Hold</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="edit-task-priority">Priority</label>
                                            <select name="priority" id="edit-task-priority">
                                                <option value="low">Low</option>
                                                <option value="medium">Medium</option>
                                                <option value="high">High</option>
                                            </select>
                                        </div>
                                    </div>
                                </form>
                                <div class="footer">
                                    <button type="submit" class="col-md-3 btn-success" id="update-task">Update</button>
                                    <button type="button" class="col-md-3 btn-danger mp-close">Cancel</button>
                                </div>
                            </div>
                        </div>
                        <!-- New Task Board Popup -->
                        <div class="mp-popup" id="new-task-board">
                            <div class="mp-popup-content">
                                <div class="mp-d-flex heading">
                                    <h4>New Job</h4>
                                    <span class="mp-close">✖</span>
                                </div>
                                <form id="mp-add-task-board">
                                    <label for="task-board-title">Title <span class="required" title="required">*</span></label>
                                    <input type="text" name="task-board-title" id="task-board-title" autocomplete="off" required>
                                    <div class="footer">
                                        <button type="submit" class="col-md-3 btn-success" id="bt-task-board">Add</button>
                                        <button type="button" class="col-md-3 btn-danger mp-close">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Edit Task Board Popup -->
                        <div class="mp-popup" id="edit-task-board">
                            <div class="mp-popup-content">
                                <div class="mp-d-flex heading">
                                    <h4>Edit Job</h4>
                                    <span class="mp-close">✖</span>
                                </div>
                                <form id="mp-editfrm-task-board">
                                    <label for="task-board-title">Title <span class="required" title="required">*</span></label>
                                    <input type="text" name="edit-task-board-title" id="edit-task-board-title" autocomplete="off" required>
                                    <div class="footer">
                                        <button type="submit" class="col-md-3 btn-success" id="update-task-board">Update</button>
                                        <button type="button" class="col-md-3 btn-danger mp-close">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>


@endsection