@extends('layouts.dashboard.app')

@section('title', 'Manufacturing Order')

@section('content')

<!-- Page Heading -->
<x-layout.page-header title="Machine management" icon="industry" iconColor="info" />

                    <!-- Content Row -->
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="projects-section-header">
                                <a href="#" class="btn btn-primary btn-icon-split" id="add-project-box" onclick="newProjectPopup()">
                                    <span class="icon text-white-30">
                                        <i class="fas fa-file-alt"></i>
                                    </span>
                                    <span class="text">New</span>
                                </a>
                            </div>
                            <!-- Project Planning Start -->
                            <div class="projects-section">
                                <div class="projects-section-line">
                                    <div class="projects-status">

                                    </div>
                                    <div class="view-actions">
                                        <button class="view-btn list-view" title="List View">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-list">
                                                <line x1="8" y1="6" x2="21" y2="6" />
                                                <line x1="8" y1="12" x2="21" y2="12" />
                                                <line x1="8" y1="18" x2="21" y2="18" />
                                                <line x1="3" y1="6" x2="3.01" y2="6" />
                                                <line x1="3" y1="12" x2="3.01" y2="12" />
                                                <line x1="3" y1="18" x2="3.01" y2="18" />
                                            </svg>
                                        </button>
                                        <button class="view-btn grid-view" title="Grid View">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-grid">
                                                <rect x="3" y="3" width="7" height="7" />
                                                <rect x="14" y="3" width="7" height="7" />
                                                <rect x="14" y="14" width="7" height="7" />
                                                <rect x="3" y="14" width="7" height="7" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                                <div class="project-boxes jsGridView">
                                    <!--Project Boxes will be created here-->
                                </div>
                            </div>

                            <!-- Project Planning End-->

                            <!-- Content Row -->


                            <!-- Content Row -->

                        </div>
                        <!-- /.container-fluid -->
                    </div>

                    <!-- Popup overlay and content -->
    <div class="new-project-popup-overlay" id="new-project-popup-overlay">
        <form class="new-project-popup-content">
            <h5>New Project Details</h5><br>
            
            <!-- Machine Select Field -->
            <label for="machine">Machine</label>
            <select id="machineNameSelect" required>
                <option value="">Select Machine</option>
                <!-- <option value="Machine 1">Machine 1</option>
                <option value="Machine 2">Machine 2</option>
                <option value="Machine 3">Machine 3</option> -->
            </select>

            <!-- Process Select Field -->
            <label for="process">Process</label>
            <select id="processSelect" required>
                <option value="">Select Process</option>
                <option value="Process A">Process A</option>
                <option value="Process B">Process B</option>
                <option value="Process C">Process C</option>
            </select>

            <!-- Start Date Field -->
            <label for="startTimer">Start Date</label>
            <input type="datetime-local" id="startTime" required>

            <!-- End Date Field -->
            <label for="endTimer">End Date</label>
            <input type="datetime-local" id="endTime" required>
            <br><br>

            <!-- Buttons for Save and Close -->
            <div class="new-project-popup-buttons">
                <button class="col-md-4 btn-success" id="newProjectSave" type="submit">Save</button>
                <button class="col-md-4 btn-danger" type="button" onclick="newProjectClosePopup()">Close</button>
            </div>
        </form>
    </div>

@endsection