@extends('layouts.dashboard.adminapp')

@section('title', 'Machine Details')
<style>
    div.dt-buttons {
        float: left;
        display: flex !important;
        margin-bottom: 1rem;
    }

    .dataTable {
        overflow-x: auto !important;
        display: table !important;
    }

    .dt-buttons .btn {
        margin-right: 0.5rem !important;
        padding: 0.25rem 0.75rem !important;
        font-size: 0.95rem !important;
    }

    .btn-delete {
        min-width: 80px;
    }

    .page-header-icon {
        font-size: 2rem;
        color: #506690;
        vertical-align: middle;
    }
</style>
@section('content')
    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Page Heading -->
    <x-layout.page-header title="UEPL / Machine Datatable" icon="cogs" iconColor="warning" />

    <!-- Card Table -->
    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center gap-3">
            <span class="fw-bold"><i class="fas fa-table me-2"></i>Machines Data</span>

            <button class="btn btn-success" style="width:auto;" data-toggle="modal" data-target="#bulkImportModal">
                <i class="fas fa-file-excel"></i> Bulk Add
            </button>
            <a href="{{ route('admin.machine.addmachine') }}" class="btn btn-primary" style="width:auto;">
                <i class="fas fa-plus"></i> New
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover text-dark w-100" id="machineTable">
                    <thead class="table-light">
                        <tr class="text-center align-middle">
                            <th>Machine ID</th>
                            <th>Machine Name</th>
                            <th>Machine SL No</th>
                            <th>Make</th>
                            <th>Model Type</th>
                            <th>Diameter (mm)</th>
                            <th>Length (m)</th>
                            <th>Weight (kg)</th>
                            <th>Remarks</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($machines as $machine)
                            <tr class="text-center align-middle" id="row-{{ $machine->id }}">
                                <td>{{ $machine->machine_id }}</td>
                                <td>{{ $machine->machine_name }}</td>
                                <td>{{ $machine->machine_sl_no }}</td>
                                <td>{{ $machine->make }}</td>
                                <td>{{ $machine->model_type }}</td>
                                <td>{{ $machine->diameter }}</td>
                                <td>{{ $machine->length }}</td>
                                <td>{{ $machine->weight }}</td>
                                <td>{{ $machine->remarks }}</td>
                                <td>
                                    <a href="{{ route('admin.machine.edit', $machine->id) }}"
                                        class="btn btn-primary btn-sm mb-1">Edit</a>
                                    <button class="btn btn-danger btn-sm delete-btn"
                                        data-id="{{ $machine->id }}">Delete</button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    </div>
    </div>
    <!-- Bulk Import Modal -->
    <div class="modal fade" id="bulkImportModal" tabindex="-1" role="dialog" aria-labelledby="bulkImportModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="POST" action="{{ route('admin.machine.import') }}" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="bulkImportModalLabel">Bulk Add Machines</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="width:auto;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="excel_file" class="form-label">Upload Excel File (.xlsx)</label>
                            <input class="form-control" type="file" id="excel_file" name="excel_file" accept=".xlsx"
                                required>
                            <small>
                                <a href="{{ asset('templates/machine_import_template.xlsx') }}" download>Download Sample
                                    Template</a>
                            </small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Import</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')

    <script>
        $(document).ready(function() {
            // DataTable with export buttons
            $('#machineTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'copy',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'colvis',
                        className: 'btn btn-secondary btn-sm'
                    }
                ],
                responsive: true,
                destroy: true,
            });

            // Handle delete button
            $(document).on('click', '.delete-btn', function() {
                var id = $(this).data('id');
                if (confirm('Are you sure you want to delete this machine?')) {
                    fetch(`{{ url('admin/deletemachine') }}/${id}`, {
                            method: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                'Accept': 'application/json',
                            },
                        })
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                $(`#row-${id}`).remove();
                            } else {
                                alert('Delete failed');
                            }
                        })
                        .catch(() => alert('Error deleting record'));
                }
            });
        });
    </script>
@endsection
