@extends('layouts.dashboard.adminapp')

@section('title', 'Leave Balance Management')

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Leave Balance</h1>
    <a href="{{ route('admin.leave.index') }}" class="btn btn-outline-primary btn-sm">
        <i class="fas fa-arrow-left mr-1"></i> Back to Leave Requests
    </a>
</div>

<!-- Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
    </div>
@endif

<!-- Year Filter -->
<div class="card shadow mb-4">
    <div class="card-header py-2" style="background: linear-gradient(135deg, #36b9cc 0%, #1e90a6 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-filter mr-2"></i> Filter</h6>
    </div>
    <div class="card-body py-3">
        <form method="GET" action="{{ route('admin.leave-balance.index') }}" class="form-inline">
            <label class="mr-2 font-weight-bold">Year:</label>
            <select class="form-control form-control-sm mr-2" name="year" onchange="this.form.submit()">
                @for($y = now()->year; $y >= now()->year - 5; $y--)
                    <option value="{{ $y }}" {{ $year == $y ? 'selected' : '' }}>{{ $y }}</option>
                @endfor
            </select>
        </form>
    </div>
</div>

<!-- Leave Balance Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-balance-scale mr-2"></i> Leave Balance - {{ $year }}
        </h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm" id="balanceTable" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>Employee ID</th>
                        <th>Employee Name</th>
                        <th>Department</th>
                        <th class="text-center">CL Balance</th>
                        <th class="text-center">SL Balance</th>
                        <th class="text-center">PL Balance</th>
                        <th class="text-center">CL Used</th>
                        <th class="text-center">SL Used</th>
                        <th class="text-center">PL Used</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($balances as $balance)
                        <tr>
                            <td>{{ $balance->employee->employee_id ?? '-' }}</td>
                            <td>{{ $balance->employee->name ?? '-' }}</td>
                            <td>{{ $balance->employee->department ?? '-' }}</td>
                            <td class="text-center"><span class="badge badge-info">{{ $balance->cl_balance ?? 0 }}</span></td>
                            <td class="text-center"><span class="badge badge-warning">{{ $balance->sl_balance ?? 0 }}</span></td>
                            <td class="text-center"><span class="badge badge-primary">{{ $balance->pl_balance ?? 0 }}</span></td>
                            <td class="text-center">{{ $balance->cl_used ?? 0 }}</td>
                            <td class="text-center">{{ $balance->sl_used ?? 0 }}</td>
                            <td class="text-center">{{ $balance->pl_used ?? 0 }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('#balanceTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        order: [[1, 'asc']]
    });
});
</script>
@endsection
