@extends('layouts.dashboard.app')

@section('title', 'Employee Payroll')

@section('content')

 <!-- Page Heading -->
 <div class="p-2 d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h5 mb-0 text-gray-800">UEPL / Employee Salary Details</h1>
                        <div class="display-date">
                            <span id="day">day</span>,
                            <span id="daynum">00</span>
                            <span id="month">month</span>
                            <span id="year">0000</span>
                        </div>
                        <div class="display-time"></div>
                    </div>

                    <!-- Content Row -->
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="projects-section-header">
                                <a href="" class="btn btn-primary btn-icon-split" id="openPopupButton"
                                    title="New Employee">
                                    <span class="icon text-white-30">
                                        <i class="fas fa-file-alt"></i>
                                    </span>
                                    <span class="text">New</span>
                                </a>
                            </div>
                            <!-- Project Planning Start -->
                            <div class="form-container">
                                <h1 class="pt-2 pb-2">Employee Salary</h1>
                                <div class="row export-buttons" id="export-buttons">
                                    <div class="col-md-1">
                                        <div class="dropdown">
                                            <button class="btn btn-primary dropdown-toggle" type="button"
                                                id="columnVisibility" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                <i class="fa fa-filter" aria-hidden="true"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="columnVisibility">
                                                <h6 class="dropdown-header">Select Columns</h6>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="0" checked> Month & Year</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="1" checked> Employee ID</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="2" checked> Employee Name</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="3" checked> Basic & DA</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="4" checked> HRA</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="5" checked> Conveyance</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="6" checked> Washing Allowance</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="7" checked> Fixed Salary</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="8" checked> No. of Days Worked</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="9" checked> Leave Given</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="10" checked> Total Days for Salary</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="11" checked> Drawn Salary</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="12" checked> Incentive Hrs</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="13" checked> Incentive Rate</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="14" checked> Incentive Amount</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="15" checked> Attendance Bonus</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="16" checked> Gross Salary</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="17" checked> ESI</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="18" checked> PF</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="19" checked> PT</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="20" checked> Advance Deduction</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="21" checked> Net Salary</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="22" checked> Payment Mode</label>
                                                </div>
                                                <div class="dropdown-item">
                                                    <label><input type="checkbox" class="column-toggle" value="23" checked> Actions</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                    <div class="col-md-1">
                                        <button id="copy" class="btn btn-primary" title="Copy"><i
                                                class="fa fa-file-alt"></i></button>
                                    </div>
                                    <div class="col-md-1">
                                        <button id="export-csv" class="btn btn-primary" title="CSV"><i
                                                class="fa fa-table"></i></button>
                                    </div>
                                    <div class="col-md-1">
                                        <button id="export-pdf" class="btn btn-primary" title="PDF"><i
                                                class="fa fa-file-pdf"></i></button>
                                    </div>
                                    <div class="col-md-1">
                                        <button id="export-excel" class="btn btn-primary" title="Excel"><i
                                                class="fa fa-file-excel"></i></button>
                                    </div>
                                    <div class="col-md-1">
                                        <button id="print" class="btn btn-primary" title="Print"><i
                                                class="fa fa-print"></i></button>
                                    </div>
                                    <div class="col-md-1">
                                        <button id="import-button" class="btn btn-primary" title="Import Details"><i
                                                class="fa fa-arrow-circle-down" aria-hidden="true"></i></button>
                                    </div>
                                </div>
                                <!-- Filter/Search Box -->
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered header-sticky" id="dataTable" width="100%"
                                            cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th>Month & Year</th>
                                                    <th>Employee ID</th>
                                                    <th>Employee Name</th>
                                                    <th>Basic & DA</th>
                                                    <th>HRA</th>
                                                    <th>Conveyance</th>
                                                    <th>Washing Allowance</th>
                                                    <th>Fixed Salary</th>
                                                    <th>No. of Days Worked</th>
                                                    <th>Leave Given</th>
                                                    <th>Total Days for Salary</th>
                                                    <th>Drawn Salary</th>
                                                    <th>Incentive Hrs</th>
                                                    <th>Incentive Rate</th>
                                                    <th>Incentive Amount</th>
                                                    <th>Attendance Bonus</th>
                                                    <th>Gross Salary</th>
                                                    <th>ESI</th>
                                                    <th>PF</th>
                                                    <th>PT</th>
                                                    <th>Advance Deduction</th>
                                                    <th>Net Salary</th>
                                                    <th>Payment Mode</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                    <th>Month & Year</th>
                                                    <th>Employee ID</th>
                                                    <th>Employee Name</th>
                                                    <th>Basic & DA</th>
                                                    <th>HRA</th>
                                                    <th>Conveyance</th>
                                                    <th>Washing Allowance</th>
                                                    <th>Fixed Salary</th>
                                                    <th>No. of Days Worked</th>
                                                    <th>Leave Given</th>
                                                    <th>Total Days for Salary</th>
                                                    <th>Drawn Salary</th>
                                                    <th>Incentive Hrs</th>
                                                    <th>Incentive Rate</th>
                                                    <th>Incentive Amount</th>
                                                    <th>Attendance Bonus</th>
                                                    <th>Gross Salary</th>
                                                    <th>ESI</th>
                                                    <th>PF</th>
                                                    <th>PT</th>
                                                    <th>Advance Deduction</th>
                                                    <th>Net Salary</th>
                                                    <th>Payment Mode</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                                <!-- Employee data will be inserted here -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!-- Data Table -->
                            </div>
                        </div>
                    </div>


    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close" style="width: auto;">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="login.html">Logout</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Import Modal -->
    <div class="modal fade" id="importModal" tabindex="-1" role="dialog" aria-labelledby="importModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="importModalLabel">Import Employer Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="width: auto;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="import-form" enctype="multipart/form-data">
                        <div class="form-group">
                            <label for="excelFile">Choose Excel File:</label>
                            <input type="file" class="form-control" id="excelFile" accept=".xlsx, .xls">
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="importDataBtn">OK</button>
                </div>
            </div>
        </div>
    </div>

    <!-- PDF View Modal -->
    <div class="modal fade" id="pdfModal" tabindex="-1" role="dialog" aria-labelledby="pdfModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document" style="max-width: 60%; width: auto;">
            <div class="modal-content" style="height: 85vh;">
                <div class="modal-header">
                    <h5 class="modal-title" id="pdfModalLabel"> Employee Details View</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="width: auto;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <iframe id="pdfViewer" src="" width="100%" height="600px"></iframe>
                </div>
            </div>
        </div>
    </div>

    <!-- Popup Overlay for New Employer -->
    <div class="new-employer-popup-overlay" id="new-employer-popup-overlay">
        <form class="new-employer-popup-content" id="newEmployerForm">
            <h5>New Employee Salary</h5><br>
            <div class="row">
                <div class="col-lg-12">
                    <h3>UMBREY ENGINEERING PVT LTD
                        </h3>
                    </div>
                <div class="hidden"><input type="text" id="employeeIdHidden" name="id"></div>

                <div class="col-md-4">
                    <label for="monthYear">Month & Year: <span class="required" title="required">*</span></label>
                    <input type="month" id="monthYear" name="monthYear" placeholder="Month & Year" required>
                </div>
                <div class="col-md-4">
                    <label for="employeeId">Employee ID: <span class="required" title="required">*</span></label>
                    <!-- <input type="text" id="employeeId" placeholder="employeeID" name="employeeId" required> -->
                    <input type="text" id="employeeId" placeholder="Employee ID" name="employeeId" list="employeeIdList" required>
                    <datalist id="employeeIdList"></datalist> <!-- Datalist for employee IDs -->
                </div>
                <div class="col-md-4">
                    <label for="employeeName">Employee Name: <span class="required" title="required">*</span></label>
                    <input type="text" id="employeeName" name="employeeName" placeholder="Employee Name" required>
                </div>
            </div><br>
            <div class="row">
                <div class="col-md-4">
                    <label>Basic & DA:</label>
                    <input type="number" id="basicDA" oninput="calculateSalary()">
                </div>
                <div class="col-md-4">
                    <label>HRA:</label>
                    <input type="number" id="hra" oninput="calculateSalary()">
                </div>
                <div class="col-md-4">
                    <label>Conveyance:</label>
                    <input type="number" id="conveyance" oninput="calculateSalary()">
                </div>
            </div><br>
            <div class="row">
                <div class="col-md-4">
                    <label>Washing Allowance:</label>
                    <input type="number" id="washingAllowance" oninput="calculateSalary()">
                </div>
                <div class="col-md-4">
                    <label>Fixed Salary:</label>
                    <input type="number" id="fixedSalary" readonly>
                </div>
                <div class="col-md-4">
                    <label>No. of Days Worked:</label>
                    <input type="number" id="daysWorked" oninput="calculateSalary()">
                </div>
            </div><br>

            <div class="row">
                <div class="col-md-4">
                    <label>Leave Given:</label>
                    <input type="number" id="leaveGiven" oninput="calculateSalary()">
                </div>
                <div class="col-md-4">
                    <label>Total Days for Salary:</label>
                    <input type="number" id="totalDays" readonly>
                </div>
                <div class="col-md-4">
                    <label>Drawn Salary:</label>
                    <input type="number" id="drawnSalary" readonly>

                </div>
            </div><br>

            <div class="row">
                <div class="col-md-4">
                    <label>Incentive Hrs:</label>
                    <input type="number" id="incentiveHrs" oninput="calculateSalary()">
                </div>
                <div class="col-md-4">
                    <label>Incentive Rate:</label>
                    <input type="number" id="incentiveRate" oninput="calculateSalary()">
                </div>
                <div class="col-md-4">
                    <label>Incentive Amount:</label>
                    <input type="number" id="incentiveAmount" readonly>
                </div>
            </div><br>
            <div class="row">
                <div class="col-md-4">
                    <label>Attendance Bonus:</label>
                    <input type="number" id="attendanceBonus" oninput="calculateSalary()">
                </div>
                <div class="col-md-4">
                    <label>Gross Salary:</label>
                    <input type="number" id="grossSalary" readonly>
                </div>
                <div class="col-md-4">
                    <label>ESI:</label>
                    <input type="number" id="esi" oninput="calculateSalary()">
                </div>
            </div><br>
            <div class="row">
                <div class="col-md-4">
                    <label>PF:</label>
                    <input type="number" id="pf" oninput="calculateSalary()">
                </div>
                <div class="col-md-4">
                    <label>PT:</label>
                    <input type="number" id="pt" oninput="calculateSalary()">
                </div>
                <div class="col-md-4">
                    <label>Advance Deduction:</label>
                    <input type="number" id="advanceDeduction" oninput="calculateSalary()">
                </div>
            </div> <br>
            <div class="row">
                <div class="col-md-4">
                    <label>Net Salary:</label>
                    <input type="number" id="netSalary" readonly>
                </div>
                <div class="col-md-6">
                    <label>Payment Mode:</label>
        <select id="payMode">
            <option value="Cash">Cash</option>
            <option value="Bank Transfer">Bank Transfer</option>
            <option value="Cheque">Cheque</option>
        </select>
                </div>
            </div>
            <br>

            <div class="new-employer-popup-buttons">
                <button class="btn btn-success" id="newemployeeSave" type="submit">Save</button>
                <button class="btn btn-danger" type="button" id="closePopup">Close</button>
            </div>
        </form>
    </div>

    <script src={{ asset('js\employer-salary.js') }}></script>

@endsection