@extends('layouts.dashboard.adminapp')

@section('title', 'All Dashboard')

@section('content')

    <div class="container-fluid">

        <!-- Page Heading -->
        <x-layout.page-header title="UEPL / Dashboard" icon="tachometer-alt" iconColor="primary" />
        <!-- Content Row -->
        <div class="row">

            <!-- Earnings (Monthly) Card Example -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                    Month</div>
                                <p>Total Customers</p>
                                <div class="h5 mb-0 font-weight-bold text-gray-800" data-target="100">
                                    {{ $totalCustomerMonthly }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-users fa-3x text-primary"></i>
                            </div>
                        </div>

                    </div>
                    <!--<div class="col mr-3 pb-4">-->
                    <!--    <a href="#" class="btn btn-light btn-icon-split">-->
                    <!--        <span class="text">View More</span>-->
                    <!--    </a>-->
                    <!--</div>-->
                </div>
            </div>

            <!-- Earnings (Monthly) Card Example -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-success text-uppercase mb-1">
                                    Annual</div>
                                <p>Total Customers</p>
                                <div class="h5 mb-0 font-weight-bold text-gray-800" data-target="1000">
                                    {{ $totalCustomerAnnual }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-users fa-3x text-success"></i>
                            </div>
                        </div>
                    </div>
                    <!--<div class="col mr-3 pb-4">-->
                    <!--    <a href="#" class="btn btn-light btn-icon-split">-->
                    <!--        <span class="text">View More</span>-->
                    <!--    </a>-->
                    <!--</div>-->
                </div>
            </div>

            <!-- Earnings (Monthly) Card Example -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-info shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-info text-uppercase mb-1"> Day
                                    Tasks
                                </div>
                                <div class="row no-gutters align-items-center">
                                    <div class="col-auto">
                                        <div class="h5 mb-0 mr-3 font-weight-bold text-gray-800">
                                            {{ number_format($dayTasksPercent, 2) }}%</div>
                                    </div>
                                    <div class="col">
                                        <div class="progress progress-sm mr-2">
                                            <div class="progress-bar bg-info" role="progressbar"
                                                style="width: {{ $dayTasksPercent }}%"
                                                aria-valuenow="{{ $dayTasksPercent }}" aria-valuemin="0"
                                                aria-valuemax="100"></div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-tasks fa-3x text-info"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col mr-3 pb-4">
                        <a href="#" class="btn btn-light btn-icon-split">
                            <span class="text">View More</span>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Pending Requests Card Example -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-warning text-uppercase mb-1">
                                    Pending Bills to Approve</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800" data-target="18">{{ $pendingBills }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-list-alt fa-3x text-warning"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col mr-3 pb-4">
                        <a href="#" class="btn btn-light btn-icon-split">
                            <span class="text">View More</span>
                        </a>
                    </div>
                </div>

            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-secondary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-secondary text-uppercase mb-1">
                                    Running Projects</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800" data-target="50">{{ $runningProjects }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas  fa-briefcase fa-3x text-secondary"></i>
                            </div>
                        </div>

                    </div>
                    <div class="col mr-3 pb-4">
                        <a href="#" class="btn btn-light btn-icon-split">
                            <span class="text">View More</span>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-warning text-uppercase mb-1">
                                    Today's Present Employees</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800" data-target="50">{{ $employeePresent }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-user-circle fa-3x text-warning"></i>
                            </div>
                        </div>

                    </div>
                    <div class="col mr-3 pb-4">
                        <a href="#" class="btn btn-light btn-icon-split">
                            <span class="text">View More</span>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-danger shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-danger text-uppercase mb-1">
                                    Today's Leave Employees</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800" data-target="50">{{ $employeeLeave }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-user-circle fa-3x text-danger"></i>
                            </div>
                        </div>

                    </div>
                    <div class="col mr-3 pb-4">
                        <a href="#" class="btn btn-light btn-icon-split">
                            <span class="text">View More</span>
                        </a>
                    </div>
                </div>
            </div>


        </div>
        <hr>
    
    </div>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

@endsection

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src={{ asset('js/alldashboard.js') }}></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const data = [{
                company: "Company A",
                company: 120,
                revenue: 50
            },
            {
                company: "Company B",
                company: 190,
                revenue: 80
            },
            {
                company: "Company C",
                company: 300,
                revenue: 150
            },
            {
                company: "Company D",
                company: 150,
                revenue: 70
            },
            {
                company: "Company E",
                company: 220,
                revenue: 120
            },
            {
                company: "Company F",
                company: 180,
                revenue: 90
            },
            {
                company: "Company G",
                company: 250,
                revenue: 130
            },
            {
                company: "Company H",
                company: 210,
                revenue: 110
            }
        ];

        const companies = data.map(item => item.company);
        const company = data.map(item => item.company);
        const revenue = data.map(item => item.revenue);

        // Apply condition: Highlight companies with high revenue
        const backgroundColors = data.map(item =>
            item.revenue > 100 ? "rgba(255, 99, 132, 0.7)" : "rgba(54, 162, 235, 0.7)"
        );

        const ctx = document.getElementById("customerRevenueChart").getContext("2d");
        new Chart(ctx, {
            type: "bar",
            data: {
                labels: companies,
                datasets: [{
                        label: "company",
                        data: company,
                        backgroundColor: "rgba(54, 162, 235, 0.7)",
                        borderColor: "rgba(54, 162, 235, 1)",
                        borderWidth: 1
                    },
                    {
                        label: "Revenue (₹K)",
                        data: revenue,
                        backgroundColor: backgroundColors,
                        borderColor: "rgba(255, 99, 132, 1)",
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: "top",
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: "Values"
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: "Companies"
                        }
                    }
                }
            }
        });
    });
</script>
