@extends('layouts.dashboard.adminapp')

@section('title', 'Customer/Vendor Details')

@section('content')
    <style>
        .custom-card {
            background: linear-gradient(120deg, #f6d365 0%, #fda085 100%);
            border: none;
            border-radius: 1.2rem;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.09);
            overflow: hidden;
            margin-bottom: 2rem;
        }

        .custom-card-header {
            background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%);
            padding: 1.5rem 2rem 1rem 2rem;
            color: #222;
            border-top-left-radius: 1.2rem;
            border-top-right-radius: 1.2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .custom-card-header h3 {
            margin-bottom: 0;
            font-weight: 700;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .custom-card-body {
            background: white;
            border-bottom-left-radius: 1.2rem;
            border-bottom-right-radius: 1.2rem;
            padding: 2rem;
        }

        .detail-label {
            color: #4f4f4f;
            font-weight: 600;
            min-width: 160px;
        }

        .detail-value {
            font-weight: 700;
            color: #2b2b2b;
            word-break: break-all;
        }

        .rc-back-btn {
            min-width: 130px;
            border-radius: 2rem;
            font-size: 1.1rem;
            font-weight: 600;
            box-shadow: 0 3px 18px rgba(253, 160, 133, 0.09);
        }

        .table-header-gradient {
            background: #fda085;
            color: #fff;
            border: none;
            font-weight: 600;
        }

        .badge-status {
            font-size: 1rem;
            padding: .5em 1em;
            border-radius: 2rem;
        }
        .rc-table th {
            background: #fda085;
            color: #fff;
            border: none;
            font-weight: 600;
        }
        @media (max-width: 991px) {
            .custom-card-body {
                padding: 1.2rem;
            }

            .custom-card-header {
                padding: 1rem 1rem .7rem 1rem;
            }
        }
    </style>

    <div class="container-fluid">
        <div class="row justify-content-center py-4">
            <div class="col-12 col-lg-10">
                <div class="card custom-card">
                    <div class="custom-card-header">
                        <h3>
                            <i class="fas fa-user-tie"></i> Customer / Vendor Full Details
                        </h3>
                        <a href="{{ route('admin.customer.customerlist') }}" class="btn btn-light rc-back-btn">
                            <i class="fa fa-arrow-left"></i> Back
                        </a>
                    </div>
                    <div class="custom-card-body">
                        <div class="row">
                            <!-- Left: Company & Address -->
                            <div class="col-md-6">
                                <h5 class="mb-3"><i class="fas fa-building me-2"></i>Company Details</h5>
                                <div class="mb-3"><span class="detail-label">Company Name:</span> <span
                                        class="detail-value">{{ $customer->company }}</span></div>
                                <div class="mb-3"><span class="detail-label">Company Nickname:</span> <span
                                        class="detail-value">{{ $customer->company_nickname }}</span></div>
                                <div class="mb-3"><span class="detail-label">Email:</span> <span
                                        class="detail-value">{{ $customer->email }}</span></div>
                                <div class="mb-3"><span class="detail-label">Mobile:</span> <span
                                        class="detail-value">{{ $customer->mobile }}</span></div>
                                <div class="mb-3"><span class="detail-label">Company Type:</span> <span
                                        class="detail-value">{{ $customer->company_type }}</span></div>
                                <div class="mb-3"><span class="detail-label">Company Role:</span> <span
                                        class="detail-value">{{ $customer->company_role }}</span></div>
                                <div class="mb-3"><span class="detail-label">GST No:</span> <span
                                        class="detail-value">{{ $customer->gstno }}</span></div>
                                <div class="mb-3"><span class="detail-label">PAN No:</span> <span
                                        class="detail-value">{{ $customer->panno }}</span></div>
                                <div class="mb-3"><span class="detail-label">MSME No:</span> <span
                                        class="detail-value">{{ $customer->msmeno }}</span></div>
                                <div class="mb-3"><span class="detail-label">IEC No:</span> <span
                                        class="detail-value">{{ $customer->iecno }}</span></div>
                                <div class="mb-3"><span class="detail-label">Website:</span>
                                    @if ($customer->url)
                                        <a href="{{ $customer->url }}" target="_blank">{{ $customer->url }}</a>
                                    @else
                                        <span class="detail-value">Not Provided</span>
                                    @endif
                                </div>
                                <div class="mb-3">
                                    <span class="detail-label">Status:</span>
                                    @if ($customer->status == 1)
                                        <span class="badge badge-status bg-success">Active</span>
                                    @else
                                        <span class="badge badge-status bg-danger">Inactive</span>
                                    @endif
                                </div>
                                <div class="mb-3">
                                    <span class="detail-label">Logo:</span><br>
                                    @if ($customer->image)
                                        <img src="{{ asset('storage/' . $customer->image) }}" width="100"
                                            class="rounded mt-1">
                                    @else
                                        <span class="detail-value">No Logo Uploaded</span>
                                    @endif
                                </div>
                                <hr>
                                <h5 class="mb-3"><i class="fas fa-map-marker-alt me-2"></i>Address Details</h5>
                                <div class="mb-2"><span class="detail-label">Billing Address:</span> <span
                                        class="detail-value">{{ $customer->billing_Address ?? '-' }}</span></div>
                                <div class="mb-2"><span class="detail-label">Shipping Address:</span> <span
                                        class="detail-value">{{ $customer->shipping_Address ?? '-' }}</span></div>
                            </div>

                            <!-- Right: Bank & Contacts -->
                            <div class="col-md-6">
                                <h5 class="mb-3"><i class="fas fa-university me-2"></i>Bank Details</h5>
                                <div class="mb-3"><span class="detail-label">Bank Name:</span> <span
                                        class="detail-value">{{ $customer->bank_name }}</span></div>
                                <div class="mb-3"><span class="detail-label">Branch Name:</span> <span
                                        class="detail-value">{{ $customer->branch_name }}</span></div>
                                <div class="mb-3"><span class="detail-label">Account Number:</span> <span
                                        class="detail-value">{{ $customer->account_number }}</span></div>
                                <div class="mb-3"><span class="detail-label">Account Type:</span> <span
                                        class="detail-value">{{ $customer->account_type }}</span></div>
                                <div class="mb-3"><span class="detail-label">Account Holder Name:</span> <span
                                        class="detail-value">{{ $customer->account_holder_name }}</span></div>
                                <div class="mb-3"><span class="detail-label">Currency:</span> <span
                                        class="detail-value">{{ $customer->account_currency ?? 'INR' }}</span></div>
                                <div class="mb-3"><span class="detail-label">IFSC Code:</span> <span
                                        class="detail-value">{{ $customer->ifsc_code }}</span></div>
                                <div class="mb-3"><span class="detail-label">SWIFT Code:</span> <span
                                        class="detail-value">{{ $customer->swift_code ?? '-' }}</span></div>
                                <hr>
                                
                                
                            </div>
                        </div>
                        <h5 class="mb-3 mt-3"><i class="fas fa-users me-2"></i>Contact Persons</h5>
                                @if ($customer->contactPersons->count())
                                    <div class="table-responsive">
                                        <table class="table rc-table table-bordered table-striped" style="background: #fff;">
                                            <thead
                                                style="background: linear-gradient(90deg,#fda085,#f6d365); color: #fff;">
                                                <tr>
                                                    <th>#</th>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Mobile</th>
                                                    <th>Designation</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($customer->contactPersons as $idx => $contact)
                                                    <tr>
                                                        <td>{{ $idx + 1 }}</td>
                                                        <td>{{ $contact->name }}</td>
                                                        <td>{{ $contact->email }}</td>
                                                        <td>{{ $contact->mobile }}</td>
                                                        <td>{{ $contact->designation ?? '-' }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <span class="detail-value">No Contact Persons Available.</span>
                                @endif

                        <div class="d-flex justify-content-end mt-4">
                            <a href="{{ route('admin.customer.customerlist') }}" class="btn btn-light rc-back-btn">
                                <i class="fa fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
