@extends('layouts.dashboard.adminapp')

@section('title', 'Edit Customer/Vendor')

@section('content')
<x-layout.page-header title="UEPL / Edit Customer/Vendor" icon="users" iconColor="primary" />

<div class="row">
    <div class="col-lg-12">
        <div class="projects-section-header">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show">{{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show">{{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
        </div>

        <div class="form-container">
            <h1 class="pt-5 pb-5">Edit Customer/Vendor</h1>
            <form id="customerForm" action="{{ route('admin.customer.update', $customer->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-12">
                        <label>Company Role <span class="required">*</span></label>
                        <div class="d-flex">
                            @foreach(['Customer','Vendor','Both'] as $role)
                                <div class="form-check me-3" style="padding-left: 11.25rem !important;margin-top: -30px;margin-bottom: 20px;">
                                    <input type="radio" id="{{ strtolower($role) }}" name="company_role" value="{{ $role }}" class="form-check-input" {{ $customer->company_role == $role ? 'checked' : '' }} required>
                                    <label for="{{ strtolower($role) }}" class="form-check-label">{{ $role == 'Both' ? 'Customer & Vendor' : $role }}</label>
                                </div>
                            @endforeach
                        </div>
                        @error('company_role') <span class="text-danger">{{ $message }}</span> @enderror
                        <span class="text-danger d-none" id="companyRoleError">Please select a company role.</span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <label>Company Name <span class="required">*</span></label>
                        <input type="text" name="company" class="form-control" value="{{ old('company', $customer->company) }}" required>
                    </div>
                    <div class="col-md-6">
                        <label>Company Email <span class="required">*</span></label>
                        <input type="email" name="email" class="form-control" value="{{ old('email', $customer->email) }}" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <label>Company Acronym</label>
                        <input type="text" name="company_nickname" class="form-control" value="{{ old('company_nickname', $customer->company_nickname) }}">
                    </div>
                    <div class="col-md-6">
                        <label>Company Logo</label>
                        @if($customer->image)
                            <div class="mb-1"><img src="{{ asset('storage/'.$customer->image) }}" width="80"></div>
                        @endif
                        <input type="file" name="image" accept="image/*" class="form-control">
                        <small class="text-muted">Leave blank to keep existing</small>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-6">
                                <label>Company Contact Number <span class="required">*</span></label>
                                <input type="tel" name="mobile" class="form-control" value="{{ old('mobile', $customer->mobile) }}" required>
                            </div>
                            <div class="col-md-6">
                                <label>Secondary Contact Number</label>
                                <input type="tel" name="secondary_mobile" class="form-control" value="{{ old('secondary_mobile', $customer->secondary_mobile) }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <label>Type of Company <span class="required">*</span></label>
                        <select name="company_type" id="company_type" class="form-control" required>
                            <option value="" disabled>Select company type</option>
                            @foreach($companyTypes as $type)
                                    <option value="{{ $type->companytype }}"
                                        {{ $customer->company_type == $type->companytype ? 'selected' : '' }}>
                                        {{ $type->companytype }}
                                    </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <label>GST <span class="required">*</span></label>
                        <input type="text" name="gstno" class="form-control" value="{{ old('gstno', $customer->gstno) }}" required>
                    </div>
                    <div class="col-md-6">
                        <label>Company PAN <span class="required">*</span></label>
                        <input type="text" name="panno" class="form-control" value="{{ old('panno', $customer->panno) }}" required>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <label>MSME/Udyam</label>
                        <input type="text" name="msmeno" class="form-control" value="{{ old('msmeno', $customer->msmeno) }}">
                    </div>
                    <div class="col-md-6">
                        <label>IEC</label>
                        <input type="text" name="iecno" class="form-control" value="{{ old('iecno', $customer->iecno) }}">
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <label>Billing Address</label>
                        <textarea name="billing_address" class="form-control" rows="2">{{ old('billing_address', $customer->billing_address) }}</textarea>
                    </div>
                    <div class="col-md-6">
                        <label>Shipping Address</label>
                        <textarea name="shipping_address" class="form-control" rows="2">{{ old('shipping_address', $customer->shipping_address) }}</textarea>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <label>Website URL</label>
                        <input type="url" name="url" class="form-control" value="{{ old('url', $customer->url) }}">
                    </div>
                </div>

                <br><br>
                <label>Bank Account Details :</label>
                <div class="row">
                    <div class="col-md-6">
                        <label>Bank Name <span class="required">*</span></label>
                        <input type="text" name="bank_name" class="form-control" value="{{ old('bank_name', $customer->bank_name) }}" required>
                    </div>
                    <div class="col-md-6">
                        <label>Bank Branch Name <span class="required">*</span></label>
                        <input type="text" name="branch_name" class="form-control" value="{{ old('branch_name', $customer->branch_name) }}" required>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <label>Account Number <span class="required">*</span></label>
                        <input type="text" name="account_number" class="form-control" value="{{ old('account_number', $customer->account_number) }}" required>
                    </div>
                    <div class="col-md-6">
                        <label>Account Type <span class="required">*</span></label>
                        <select name="account_type" class="form-control" required>
                            <option value="" disabled>Select account type</option>
                            @foreach($accountTypes as $type)
                                <option value="{{ $type->accounttype }}"
                                    {{ $customer->account_type == $type->accounttype ? 'selected' : '' }}>
                                    {{ $type->accounttype }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <label>Account Holder Name <span class="required">*</span></label>
                        <input type="text" name="account_holder_name" class="form-control" value="{{ old('account_holder_name', $customer->account_holder_name) }}" required>
                    </div>
                    <div class="col-md-6">
                        <label>Account Currency</label>
                        <input type="text" name="account_currency" class="form-control" value="{{ old('account_currency', $customer->account_currency ?? 'INR') }}" readonly>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <label>IFSC Code <span class="required">*</span></label>
                        <input type="text" name="ifsc_code" class="form-control" value="{{ old('ifsc_code', $customer->ifsc_code) }}">
                    </div>
                    <div class="col-md-6">
                        <label>SWIFT/BIC Code</label>
                        <input type="text" name="swift_code" class="form-control" value="{{ old('swift_code', $customer->swift_code) }}">
                    </div>
                </div>

                <br>
                <!-- Contact Persons -->
                <div id="contact-person-container">
                    <h5>Contact Persons</h5>
                    @foreach ($customer->contactPersons as $i => $person)
                        <div class="contact-person row mt-3" id="contact-person-{{ $i }}">
                            <div class="col-md-12 text-end">
                                @if($i > 0)
                                    <button type="button" class="btn btn-danger btn-sm remove-contact" data-index="{{ $i }}">Remove</button>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <label for="contacts[{{ $i }}][name]">Name <span class="required">*</span></label>
                                <input type="text" name="contacts[{{ $i }}][name]" class="form-control person-name" value="{{ old("contacts.$i.name", $person->name) }}" required>
                            </div>
                            <div class="col-md-6">
                                <label for="contacts[{{ $i }}][email]">Email <span class="required">*</span></label>
                                <input type="email" name="contacts[{{ $i }}][email]" class="form-control person-email" value="{{ old("contacts.$i.email", $person->email) }}" required>
                            </div>
                        </div>
                        <div class="contact-person row mt-2" id="contact-person-extra-{{ $i }}">
                            <div class="col-md-6">
                                <label for="contacts[{{ $i }}][mobile]">Mobile <span class="required">*</span></label>
                                <input type="text" name="contacts[{{ $i }}][mobile]" class="form-control person-mobile" value="{{ old("contacts.$i.mobile", $person->mobile) }}" required>
                            </div>
                            <div class="col-md-6">
                                <label for="contacts[{{ $i }}][designation]">Designation</label>
                                <input type="text" name="contacts[{{ $i }}][designation]" class="form-control person-designation" value="{{ old("contacts.$i.designation", $person->designation) }}">
                            </div>
                        </div>
                    @endforeach
                    @if($customer->contactPersons->count() == 0)
                        <div class="contact-person row" id="contact-person-0">
                            <div class="col-md-6">
                                <label for="contacts[0][name]">Name <span class="required">*</span></label>
                                <input type="text" name="contacts[0][name]" class="form-control person-name" required>
                            </div>
                            <div class="col-md-6">
                                <label for="contacts[0][email]">Email <span class="required">*</span></label>
                                <input type="email" name="contacts[0][email]" class="form-control person-email" required>
                            </div>
                        </div>
                        <div class="contact-person row mt-2" id="contact-person-extra-0">
                            <div class="col-md-6">
                                <label for="contacts[0][mobile]">Mobile <span class="required">*</span></label>
                                <input type="text" name="contacts[0][mobile]" class="form-control person-mobile" required>
                            </div>
                            <div class="col-md-6">
                                <label for="contacts[0][designation]">Designation</label>
                                <input type="text" name="contacts[0][designation]" class="form-control person-designation">
                            </div>
                        </div>
                    @endif
                </div>
                <button type="button" class="btn btn-link mt-3" id="add-contact">+ Add Another Contact</button>

                <div class="row p-5">
                    <div class="col-md-2 pt-5 pb-5"><button class="btn btn-success" type="submit">Update</button></div>
                    <div class="col-md-2 pt-5 pb-5"><a href="{{ route('admin.customer.customerlist') }}" class="btn btn-secondary">Cancel</a></div>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- JS for dynamic contact persons --}}
<script>
document.addEventListener("DOMContentLoaded", function() {
    let contactIndex = {{ $customer->contactPersons->count() ? $customer->contactPersons->count() : 1 }};
    document.getElementById("add-contact").addEventListener("click", function() {
        let contactContainer = document.getElementById("contact-person-container");
        let newContact = `
            <div class="contact-person row mt-3" id="contact-person-${contactIndex}">
                <div class="col-md-12 text-end">
                    <button type="button" class="btn btn-danger btn-sm remove-contact" data-index="${contactIndex}">Remove</button>
                </div>
                <div class="col-md-6">
                    <label for="contacts[${contactIndex}][name]">Name <span class="required">*</span></label>
                    <input type="text" name="contacts[${contactIndex}][name]" class="form-control person-name" required>
                </div>
                <div class="col-md-6">
                    <label for="contacts[${contactIndex}][email]">Email <span class="required">*</span></label>
                    <input type="email" name="contacts[${contactIndex}][email]" class="form-control person-email" required>
                </div>
            </div>
            <div class="contact-person row mt-2" id="contact-person-extra-${contactIndex}">
                <div class="col-md-6">
                    <label for="contacts[${contactIndex}][mobile]">Mobile <span class="required">*</span></label>
                    <input type="text" name="contacts[${contactIndex}][mobile]" class="form-control person-mobile" required>
                </div>
                <div class="col-md-6">
                    <label for="contacts[${contactIndex}][designation]">Designation</label>
                    <input type="text" name="contacts[${contactIndex}][designation]" class="form-control person-designation">
                </div>
            </div>
        `;
        contactContainer.insertAdjacentHTML("beforeend", newContact);
        contactIndex++;
    });

    // Remove a contact person
    document.getElementById("contact-person-container").addEventListener("click", function(event) {
        if (event.target.classList.contains("remove-contact")) {
            let index = event.target.dataset.index;
            document.getElementById(`contact-person-${index}`).remove();
            document.getElementById(`contact-person-extra-${index}`).remove();
        }
    });
});

function toggleOtherInput() {
    let companyType = document.getElementById('company_type').value;
    document.getElementById('other-input').style.display = (companyType === "Other") ? "block" : "none";
}
</script>
@endsection
