@extends('layouts.dashboard.adminapp')

@section('title', 'Accounts Payable - Aging Report')

@section('styles')
<style>
    .aging-card {
        border-radius: 10px;
        overflow: hidden;
    }
    .aging-header-current { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .aging-header-30 { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .aging-header-60 { background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%); }
    .aging-header-90 { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    
    .aging-total {
        font-size: 1.5rem;
        font-weight: bold;
    }
    .grand-total-card {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
    }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">
        <a href="{{ route('admin.accounts.payable.index') }}" class="text-decoration-none">
            <i class="fas fa-arrow-left mr-2"></i>
        </a>
        Accounts Payable - Aging Report
    </h1>
    <button onclick="window.print()" class="btn btn-secondary btn-sm">
        <i class="fas fa-print mr-1"></i> Print Report
    </button>
</div>

<!-- Grand Total -->
<div class="row mb-4">
    <div class="col-12">
        <div class="grand-total-card">
            <div class="text-uppercase mb-2">Total Outstanding Payables</div>
            <div class="aging-total">₹{{ number_format($grandTotal, 2) }}</div>
        </div>
    </div>
</div>

<!-- Aging Buckets Summary -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="card aging-card shadow">
            <div class="card-header aging-header-current text-white">
                <h6 class="mb-0"><i class="fas fa-check-circle mr-2"></i> Current (0-30 days)</h6>
            </div>
            <div class="card-body text-center">
                <div class="aging-total text-success">₹{{ number_format($aging['current']['total'], 2) }}</div>
                <div class="text-muted">{{ $aging['current']['items']->count() }} bills</div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card aging-card shadow">
            <div class="card-header aging-header-30 text-white">
                <h6 class="mb-0"><i class="fas fa-clock mr-2"></i> 31-60 Days</h6>
            </div>
            <div class="card-body text-center">
                <div class="aging-total text-warning">₹{{ number_format($aging['days_30']['total'], 2) }}</div>
                <div class="text-muted">{{ $aging['days_30']['items']->count() }} bills</div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card aging-card shadow">
            <div class="card-header aging-header-60 text-white">
                <h6 class="mb-0"><i class="fas fa-exclamation-triangle mr-2"></i> 61-90 Days</h6>
            </div>
            <div class="card-body text-center">
                <div class="aging-total" style="color: #fd7e14;">₹{{ number_format($aging['days_60']['total'], 2) }}</div>
                <div class="text-muted">{{ $aging['days_60']['items']->count() }} bills</div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card aging-card shadow">
            <div class="card-header aging-header-90 text-white">
                <h6 class="mb-0"><i class="fas fa-exclamation-circle mr-2"></i> 90+ Days</h6>
            </div>
            <div class="card-body text-center">
                <div class="aging-total text-danger">₹{{ number_format($aging['days_90_plus']['total'], 2) }}</div>
                <div class="text-muted">{{ $aging['days_90_plus']['items']->count() }} bills</div>
            </div>
        </div>
    </div>
</div>

<!-- Detailed Tables -->
@foreach(['current' => 'Current (0-30 days)', 'days_30' => '31-60 Days', 'days_60' => '61-90 Days', 'days_90_plus' => '90+ Days'] as $key => $label)
    @if($aging[$key]['items']->count() > 0)
    <div class="card shadow mb-4">
        <div class="card-header py-3 aging-header-{{ $key == 'current' ? 'current' : ($key == 'days_30' ? '30' : ($key == 'days_60' ? '60' : '90')) }}">
            <h6 class="m-0 font-weight-bold text-white">
                {{ $label }} - ₹{{ number_format($aging[$key]['total'], 2) }}
            </h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-sm table-striped">
                    <thead class="thead-light">
                        <tr>
                            <th>Bill No</th>
                            <th>Date</th>
                            <th>Vendor</th>
                            <th>Days Old</th>
                            <th class="text-right">Total</th>
                            <th class="text-right">Paid</th>
                            <th class="text-right">Balance</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($aging[$key]['items'] as $payable)
                            @php
                                $daysOld = \Carbon\Carbon::parse($payable->purchase_date)->diffInDays(now());
                            @endphp
                            <tr>
                                <td>
                                    <a href="{{ route('admin.accounts.payable.show', $payable->id) }}">
                                        {{ $payable->purchase_no }}
                                    </a>
                                </td>
                                <td>{{ \Carbon\Carbon::parse($payable->purchase_date)->format('d M Y') }}</td>
                                <td>{{ $payable->vendor->company_name ?? 'N/A' }}</td>
                                <td>{{ $daysOld }} days</td>
                                <td class="text-right">₹{{ number_format($payable->grand_total, 2) }}</td>
                                <td class="text-right text-success">₹{{ number_format($payable->paid_amount ?? 0, 2) }}</td>
                                <td class="text-right text-danger">₹{{ number_format($payable->balance_amount ?? $payable->grand_total, 2) }}</td>
                                <td>
                                    <a href="{{ route('admin.accounts.payable.show', $payable->id) }}" 
                                       class="btn btn-sm btn-primary">Pay</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif
@endforeach

@endsection
