<?php

/**
 * Document Number Prefixes Configuration
 *
 * Centralized configuration for all document number prefixes
 * used throughout the application. This eliminates hardcoded
 * values and makes it easy to change prefixes system-wide.
 */
return [
    // ──────────────────────────────────────────────────────────────────────────
    // SALES MODULE
    // ──────────────────────────────────────────────────────────────────────────

    'rfq' => [
        'sales' => 'UEPL/S/RFQ',
        'legacy' => 'UEPL/RFQ', // Used by Admin/Manager roles
    ],

    'quotation' => [
        'sales' => 'UEPL/S/QT',
    ],

    'sales_order' => 'UEPL/SO',

    'invoice' => [
        'sales' => 'UEPL/S/INV',
    ],

    'debit_note' => 'UEPL/DN',

    // ──────────────────────────────────────────────────────────────────────────
    // PURCHASE MODULE
    // ──────────────────────────────────────────────────────────────────────────

    'purchase_rfq' => 'PRFQ',

    'purchase_quotation' => [
        'new' => 'UEPL/P/QT',
        'legacy' => 'PQT',
    ],

    'purchase_order' => [
        'new' => 'UEPL/PO',
        'legacy' => 'PO',
    ],

    'purchase_invoice' => 'UEPL/P/INV',

    'grn' => [
        'new' => 'UEPL/GRN',
        'legacy' => 'GRN',
    ],

    'credit_note' => 'UEPL/CN',

    // ──────────────────────────────────────────────────────────────────────────
    // MANUFACTURING MODULE
    // ──────────────────────────────────────────────────────────────────────────

    'route_card' => [
        'new' => 'UEPL/RC',
        'legacy' => 'RC',
    ],

    'sku' => 'SKU',

    'quality_control' => 'UEPL/QC',

    'qc_approval' => 'UEPL/QCA',

    // ──────────────────────────────────────────────────────────────────────────
    // INVENTORY MODULE
    // ──────────────────────────────────────────────────────────────────────────

    'stock_item' => 'STK',

    'raw_material' => 'RM',

    // ──────────────────────────────────────────────────────────────────────────
    // EMPLOYEE MODULE
    // ──────────────────────────────────────────────────────────────────────────

    'employee' => 'EMP',

    // ──────────────────────────────────────────────────────────────────────────
    // MASTER DATA
    // ──────────────────────────────────────────────────────────────────────────

    'machine' => 'MCH',

    // ──────────────────────────────────────────────────────────────────────────
    // FINANCE MODULE
    // ──────────────────────────────────────────────────────────────────────────

    'payment' => 'PAY',

    // ──────────────────────────────────────────────────────────────────────────
    // FORMATTING OPTIONS
    // ──────────────────────────────────────────────────────────────────────────

    'number_padding' => 4,           // Pad numbers to 4 digits (0001)
    'include_year' => true,          // Include year in some prefixes
    'year_format' => 'Y',            // Use full year (2025)
    'separator' => '/',              // Separator between prefix parts
];
