<?php

/**
 * External Assets Configuration
 *
 * Centralizes all CDN URLs and external asset configurations.
 * This allows easy version updates and fallback management.
 *
 * Usage in Blade:
 *   <script src="{{ config('assets.cdn.jquery') }}"></script>
 *   <link href="{{ config('assets.cdn.bootstrap.css') }}" rel="stylesheet">
 */
return [
    /*
    |--------------------------------------------------------------------------
    | CDN URLs
    |--------------------------------------------------------------------------
    |
    | External CDN URLs for third-party libraries.
    | Update versions here when upgrading libraries.
    |
    */
    'cdn' => [
        // Core Libraries
        'jquery' => 'https://code.jquery.com/jquery-3.6.0.min.js',

        // Bootstrap 4.6 (current version)
        'bootstrap' => [
            'css' => 'https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css',
            'js' => 'https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js',
        ],

        // DataTables
        'datatables' => [
            'css' => 'https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css',
            'js' => 'https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js',
            'bootstrap' => 'https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js',
            'buttons' => [
                'css' => 'https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap4.min.css',
                'js' => 'https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js',
                'bootstrap' => 'https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap4.min.js',
                'html5' => 'https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js',
                'print' => 'https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js',
            ],
            'responsive' => [
                'css' => 'https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap4.min.css',
                'js' => 'https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js',
            ],
        ],

        // Export Libraries (for DataTables)
        'jszip' => 'https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js',
        'pdfmake' => [
            'js' => 'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js',
            'fonts' => 'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js',
        ],

        // UI Libraries
        'fontawesome' => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css',
        'toastr' => [
            'css' => 'https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css',
            'js' => 'https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js',
        ],
        'sweetalert2' => 'https://cdn.jsdelivr.net/npm/sweetalert2@11',

        // Select2
        'select2' => [
            'css' => 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css',
            'js' => 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js',
            'bootstrap4' => 'https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css',
        ],

        // Charts
        'chartjs' => 'https://cdn.jsdelivr.net/npm/chart.js',

        // Date/Time
        'moment' => 'https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js',
        'daterangepicker' => [
            'css' => 'https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css',
            'js' => 'https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js',
        ],

        // Google Fonts
        'fonts' => [
            'poppins' => 'https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Local Fallback
    |--------------------------------------------------------------------------
    |
    | Whether to use local vendor files if CDN fails.
    | Local files should be in public/vendor/{library}/
    |
    */
    'local_fallback' => env('ASSETS_LOCAL_FALLBACK', false),

    /*
    |--------------------------------------------------------------------------
    | Integrity Hashes
    |--------------------------------------------------------------------------
    |
    | SRI (Subresource Integrity) hashes for CDN resources.
    | Add hashes for production security.
    |
    */
    'integrity' => [
        'jquery' => 'sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=',
        'bootstrap_css' => 'sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N',
        'bootstrap_js' => 'sha384-Fy6S3B9q64WdZWQUiU+q4/2Lc9npb8tCaSX9FK7E8HnRr0Jz8D6OP9dO5Vg3Q9ct',
    ],

    /*
    |--------------------------------------------------------------------------
    | Version Info
    |--------------------------------------------------------------------------
    |
    | Library version information for documentation purposes.
    |
    */
    'versions' => [
        'jquery' => '3.6.0',
        'bootstrap' => '4.6.2',
        'datatables' => '1.13.6',
        'fontawesome' => '5.15.4',
        'select2' => '4.1.0-rc.0',
        'chartjs' => 'latest',
        'toastr' => 'latest',
        'sweetalert2' => '11.x',
    ],
];
