<?php

namespace App\Services\Inventory;

use App\Services\BaseService;
use App\Repositories\ProductTypeRepository;
use App\Models\ProductType;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class ProductTypeService extends BaseService
{
    protected ProductTypeRepository $productTypeRepository;

    public function __construct(ProductTypeRepository $repository)
    {
        parent::__construct($repository);
        $this->productTypeRepository = $repository;
    }

    /**
     * Get active product types
     */
    public function getActive(): Collection
    {
        return $this->productTypeRepository->getActive();
    }

    /**
     * Get with materials count
     */
    public function getAllWithMaterialsCount(): Collection
    {
        return $this->productTypeRepository->getWithMaterialsCount();
    }

    /**
     * Search product types
     */
    public function search(string $term): Collection
    {
        return $this->productTypeRepository->search($term);
    }

    /**
     * Create product type
     */
    public function createProductType(array $data): ProductType
    {
        return DB::transaction(function () use ($data) {
            $productType = $this->create($data);
            $this->logAction('Product Type created', ['id' => $productType->id]);
            return $productType;
        });
    }

    /**
     * Get product type with raw materials
     */
    public function getWithRawMaterials(int $id): ProductType
    {
        return $this->findByIdWith($id, ['rawMaterials']);
    }
}
