<?php

namespace App\Services\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;

interface ServiceInterface
{
    /**
     * Get all records
     */
    public function getAll(): Collection;

    /**
     * Find a record by ID
     */
    public function findById(int $id): ?Model;

    /**
     * Find a record by ID or fail
     */
    public function findByIdOrFail(int $id): Model;

    /**
     * Create a new record
     */
    public function create(array $data): Model;

    /**
     * Update a record by ID
     */
    public function update(int $id, array $data): Model;

    /**
     * Delete a record by ID
     */
    public function delete(int $id): bool;

    /**
     * Paginate records
     */
    public function paginate(int $perPage = 15): LengthAwarePaginator;
}
