<?php

namespace App\Repositories;

use App\Models\PurchaseRFQ;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

class PurchaseRfqRepository extends BaseRepository
{
    protected function resolveModel(): Model
    {
        return new PurchaseRFQ();
    }

    /**
     * Get all RFQs with vendor relationship
     */
    public function getWithVendor(): Collection
    {
        return $this->with(['vendor'])->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get RFQs by vendor
     */
    public function getByVendor(int $vendorId): Collection
    {
        return $this->where('vendor_id', $vendorId)->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get RFQs by status
     */
    public function getByStatus(string $status): Collection
    {
        return $this->where('status', $status)->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get RFQs available for quotation (not yet converted)
     */
    public function getAvailableForQuotation(): Collection
    {
        return $this->where('status', 'pending')
            ->orderBy('created_at', 'desc')
            ->all();
    }

    /**
     * Get RFQs within date range
     */
    public function getByDateRange(string $start, string $end): Collection
    {
        return $this->whereBetween('created_at', [$start, $end])->all();
    }
}
