<?php

namespace App\Repositories;

use App\Models\PurchaseQuotation;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

class PurchaseQuotationRepository extends BaseRepository
{
    protected function resolveModel(): Model
    {
        return new PurchaseQuotation();
    }

    /**
     * Get quotations with vendor
     */
    public function getWithVendor(): Collection
    {
        return $this->with(['vendor'])->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get quotations by vendor
     */
    public function getByVendor(int $vendorId): Collection
    {
        return $this->where('vendor_id', $vendorId)->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get quotations by status
     */
    public function getByStatus(string $status): Collection
    {
        return $this->where('status', $status)->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get approved quotations available for purchase order
     */
    public function getAvailableForPurchaseOrder(): Collection
    {
        return $this->where('status', 'approved')
            ->orderBy('created_at', 'desc')
            ->all();
    }

    /**
     * Get quotations by RFQ
     */
    public function getByRfq(int $rfqId): Collection
    {
        return $this->where('purchase_rfq_id', $rfqId)->all();
    }
}
