<?php

namespace App\Repositories;

use App\Models\PurchaseOrder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

class PurchaseOrderRepository extends BaseRepository
{
    protected function resolveModel(): Model
    {
        return new PurchaseOrder();
    }

    /**
     * Get orders with vendor and items
     */
    public function getWithDetails(): Collection
    {
        return $this->with(['vendor', 'items'])->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get orders by vendor
     */
    public function getByVendor(int $vendorId): Collection
    {
        return $this->where('vendor_id', $vendorId)->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get orders by status
     */
    public function getByStatus(string $status): Collection
    {
        return $this->where('status', $status)->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get pending orders for GRN
     */
    public function getPendingForGrn(): Collection
    {
        return $this->where('status', 'approved')
            ->with(['vendor', 'items'])
            ->orderBy('created_at', 'desc')
            ->all();
    }

    /**
     * Get orders within date range
     */
    public function getByDateRange(string $start, string $end): Collection
    {
        return $this->whereBetween('order_date', [$start, $end])->all();
    }
}
