<?php

namespace App\Repositories;

use App\Models\ProductType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

class ProductTypeRepository extends BaseRepository
{
    protected function resolveModel(): Model
    {
        return new ProductType();
    }

    /**
     * Get all active product types
     */
    public function getActive(): Collection
    {
        return $this->where('status', 'active')
            ->orderBy('name', 'asc')
            ->all();
    }

    /**
     * Get product types with materials count
     */
    public function getWithMaterialsCount(): Collection
    {
        return $this->with(['rawMaterials'])
            ->orderBy('name', 'asc')
            ->all();
    }

    /**
     * Search product types
     */
    public function search(string $term): Collection
    {
        $query = $this->getQuery();
        $query->where('name', 'like', "%{$term}%");
        $result = $query->get();
        $this->resetQuery();
        return $result;
    }
}
