<?php

namespace App\Repositories;

use App\Models\Process;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

class ProcessRepository extends BaseRepository
{
    protected function resolveModel(): Model
    {
        return new Process();
    }

    /**
     * Get all processes with conversion type
     */
    public function getWithConversionType(): Collection
    {
        return $this->with(['productType', 'machines'])
            ->orderBy('name', 'asc')
            ->all();
    }

    /**
     * Get processes by conversion type
     */
    public function getByConversionType(int $typeId): Collection
    {
        return $this->where('product_type_id', $typeId)
            ->orderBy('name', 'asc')
            ->all();
    }

    /**
     * Get active processes
     */
    public function getActive(): Collection
    {
        return $this->where('status', 'active')
            ->orderBy('name', 'asc')
            ->all();
    }

    /**
     * Get processes with machines
     */
    public function getWithMachines(): Collection
    {
        return $this->with(['machines'])
            ->where('status', 'active')
            ->orderBy('name', 'asc')
            ->all();
    }

    /**
     * Search processes
     */
    public function search(string $term): Collection
    {
        $query = $this->getQuery();
        $query->where(function ($q) use ($term) {
            $q->where('name', 'like', "%{$term}%")
                ->orWhere('code', 'like', "%{$term}%");
        });
        $result = $query->get();
        $this->resetQuery();
        return $result;
    }
}
