<?php

namespace App\Repositories;

use App\Models\ManufacturingPlan;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

class ManufacturingPlanRepository extends BaseRepository
{
    protected function resolveModel(): Model
    {
        return new ManufacturingPlan();
    }

    /**
     * Get plans with route card details
     */
    public function getWithDetails(): Collection
    {
        return $this->with(['routeCard', 'routeCard.processes'])
            ->orderBy('created_at', 'desc')
            ->all();
    }

    /**
     * Get plans by status
     */
    public function getByStatus(string $status): Collection
    {
        return $this->where('status', $status)
            ->orderBy('created_at', 'desc')
            ->all();
    }

    /**
     * Get active plans
     */
    public function getActive(): Collection
    {
        return $this->whereIn('status', ['pending', 'in_progress'])
            ->with(['routeCard'])
            ->orderBy('priority', 'desc')
            ->all();
    }

    /**
     * Get plans by route card
     */
    public function getByRouteCard(int $routeCardId): Collection
    {
        return $this->where('route_card_id', $routeCardId)->all();
    }

    /**
     * Get plans within date range
     */
    public function getByDateRange(string $start, string $end): Collection
    {
        return $this->whereBetween('planned_date', [$start, $end])->all();
    }
}
