<?php

namespace App\Repositories;

use App\Models\Grn;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

class GrnRepository extends BaseRepository
{
    protected function resolveModel(): Model
    {
        return new Grn();
    }

    /**
     * Get GRNs with all relationships
     */
    public function getWithDetails(): Collection
    {
        return $this->with(['vendor', 'items', 'purchaseOrder'])
            ->orderBy('created_at', 'desc')
            ->all();
    }

    /**
     * Get GRNs by vendor
     */
    public function getByVendor(int $vendorId): Collection
    {
        return $this->where('vendor_id', $vendorId)->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get GRNs by status
     */
    public function getByStatus(string $status): Collection
    {
        return $this->where('status', $status)->orderBy('created_at', 'desc')->all();
    }

    /**
     * Get GRNs by purchase order
     */
    public function getByPurchaseOrder(int $poId): Collection
    {
        return $this->where('purchase_order_id', $poId)->all();
    }

    /**
     * Get pending GRNs for approval
     */
    public function getPending(): Collection
    {
        return $this->where('status', 'pending')
            ->with(['vendor', 'items'])
            ->orderBy('created_at', 'desc')
            ->all();
    }

    /**
     * Get GRNs within date range
     */
    public function getByDateRange(string $start, string $end): Collection
    {
        return $this->whereBetween('grn_date', [$start, $end])->all();
    }
}
