<?php

namespace App\Repositories;

use App\Models\EmployeeDetails;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;

class EmployeeRepository extends BaseRepository
{
    protected function resolveModel(): Model
    {
        return new EmployeeDetails();
    }

    /**
     * Get all active employees
     */
    public function getActive(): Collection
    {
        return $this->where('status', 'active')
            ->orderBy('name', 'asc')
            ->all();
    }

    /**
     * Get employees by department
     */
    public function getByDepartment(string $department): Collection
    {
        return $this->where('department', $department)
            ->where('status', 'active')
            ->orderBy('name', 'asc')
            ->all();
    }

    /**
     * Get employees by designation
     */
    public function getByDesignation(string $designation): Collection
    {
        return $this->where('designation', $designation)
            ->where('status', 'active')
            ->all();
    }

    /**
     * Search employees
     */
    public function search(string $term): Collection
    {
        $query = $this->getQuery();
        $query->where(function ($q) use ($term) {
            $q->where('name', 'like', "%{$term}%")
                ->orWhere('employee_id', 'like', "%{$term}%")
                ->orWhere('email', 'like', "%{$term}%");
        });
        $result = $query->get();
        $this->resetQuery();
        return $result;
    }

    /**
     * Get operators (for machine assignment)
     */
    public function getOperators(): Collection
    {
        return $this->where('designation', 'like', '%operator%')
            ->where('status', 'active')
            ->orderBy('name', 'asc')
            ->all();
    }
}
