<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

// Repository Interfaces
use App\Repositories\Contracts\RepositoryInterface;

// Repositories
use App\Repositories\RfqRepository;
use App\Repositories\QuotationRepository;
use App\Repositories\SalesOrderRepository;
use App\Repositories\InvoiceRepository;

// Services
use App\Services\Sales\RfqService;
use App\Services\Sales\QuotationService;
use App\Services\Sales\SalesOrderService;
use App\Services\Sales\InvoiceService;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register Repositories as singletons
        $this->app->singleton(RfqRepository::class, function ($app) {
            return new RfqRepository();
        });

        $this->app->singleton(QuotationRepository::class, function ($app) {
            return new QuotationRepository();
        });

        $this->app->singleton(SalesOrderRepository::class, function ($app) {
            return new SalesOrderRepository();
        });

        $this->app->singleton(InvoiceRepository::class, function ($app) {
            return new InvoiceRepository();
        });

        // Register Services
        $this->app->singleton(RfqService::class, function ($app) {
            return new RfqService($app->make(RfqRepository::class));
        });

        $this->app->singleton(QuotationService::class, function ($app) {
            return new QuotationService($app->make(QuotationRepository::class));
        });

        $this->app->singleton(SalesOrderService::class, function ($app) {
            return new SalesOrderService($app->make(SalesOrderRepository::class));
        });

        $this->app->singleton(InvoiceService::class, function ($app) {
            return new InvoiceService($app->make(InvoiceRepository::class));
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
