<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

// Sales Events
use App\Events\Sales\SalesOrderCreated;
use App\Events\Sales\SalesOrderStatusChanged;
use App\Events\Sales\InvoiceCreated;
use App\Events\Sales\PaymentReceived;

// Purchase Events
use App\Events\Purchase\PurchaseOrderCreated;
use App\Events\Purchase\PurchaseOrderApproved;
use App\Events\Purchase\GrnCreated;

// Manufacturing Events
use App\Events\Manufacturing\RouteCardCreated;
use App\Events\Manufacturing\ProcessStatusChanged;
use App\Events\Manufacturing\QcApprovalCompleted;

// Inventory Events
use App\Events\Inventory\StockLevelLow;

// Sales Listeners
use App\Listeners\Sales\CreateRouteCardForSalesOrder;
use App\Listeners\Sales\UpdateSalesOrderOnStatusChange;
use App\Listeners\Sales\UpdateInvoicePaymentStatus;

// Purchase Listeners
use App\Listeners\Purchase\UpdateInventoryOnGrnCreated;
use App\Listeners\Purchase\NotifyVendorOnPOApproval;

// Manufacturing Listeners
use App\Listeners\Manufacturing\UpdateRouteCardProgress;
use App\Listeners\Manufacturing\ProcessQcApproval;

// Inventory Listeners
use App\Listeners\Inventory\NotifyLowStockLevel;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        // Sales Events
        SalesOrderCreated::class => [
            CreateRouteCardForSalesOrder::class,
        ],
        SalesOrderStatusChanged::class => [
            UpdateSalesOrderOnStatusChange::class,
        ],
        InvoiceCreated::class => [
            // Add listeners for invoice creation
        ],
        PaymentReceived::class => [
            UpdateInvoicePaymentStatus::class,
        ],

        // Purchase Events
        PurchaseOrderCreated::class => [
            // Add listeners for PO creation
        ],
        PurchaseOrderApproved::class => [
            NotifyVendorOnPOApproval::class,
        ],
        GrnCreated::class => [
            UpdateInventoryOnGrnCreated::class,
        ],

        // Manufacturing Events
        RouteCardCreated::class => [
            // Add listeners for route card creation
        ],
        ProcessStatusChanged::class => [
            UpdateRouteCardProgress::class,
        ],
        QcApprovalCompleted::class => [
            ProcessQcApproval::class,
        ],

        // Inventory Events
        StockLevelLow::class => [
            NotifyLowStockLevel::class,
        ],
    ];

    /**
     * Register any events for your application.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Determine if events and listeners should be automatically discovered.
     */
    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
