<?php

namespace App\Models;

use App\Models\Traits\HasAuditFields;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalesCreditNote extends Model
{
    use SoftDeletes, HasAuditFields;

    protected $table = 'sales_credit_notes';

    protected $fillable = [
        'credit_note_no',
        'date',
        'invoice_no',
        'party_id',
        'amount',
        'reason',
        'description',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'date' => 'date',
        'amount' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // ──────────────────────────────────────────────────────────────────────────
    // RELATIONSHIPS
    // ──────────────────────────────────────────────────────────────────────────

    public function party()
    {
        return $this->belongsTo(CustomerVendor::class, 'party_id');
    }

    public function invoice()
    {
        return $this->belongsTo(TaxInvoice::class, 'invoice_no', 'invoice_no');
    }

    // ──────────────────────────────────────────────────────────────────────────
    // SCOPES
    // ──────────────────────────────────────────────────────────────────────────

    public function scopeForInvoice($query, string $invoiceNo)
    {
        return $query->where('invoice_no', $invoiceNo);
    }

    public function scopeForParty($query, int $partyId)
    {
        return $query->where('party_id', $partyId);
    }

    public function scopeInDateRange($query, $startDate, $endDate)
    {
        return $query->whereBetween('date', [$startDate, $endDate]);
    }
}
