<?php

namespace App\Models;

use App\Models\Traits\HasAuditFields;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseRFQ extends Model
{
    use HasFactory, SoftDeletes, HasAuditFields;

    protected $table = 'purchase_rfqs';

    protected $fillable = [
        'rfq_no', 'rfq_date', 'vendor_id', 'vendor_reference_no',
        'rfq_type', 'description', 'delivery_terms', 'quantity', 'uom', 'note', 'status',
        'created_by', 'updated_by', 'approved_by', 'approved_at', 'rejection_reason',
    ];

    protected $casts = [
        'rfq_date' => 'date',
        'approved_at' => 'datetime',
    ];

    public function items()
    {
        return $this->hasMany(PurchaseRFQItem::class, 'rfq_id', 'id');
    }

    public function customerInfo()
    {
        return $this->belongsTo(\App\Models\CustomerVendor::class, 'vendor_id', 'id');    
    }
    
    public function rfqFiles()
    {
        return $this->hasMany(PurchaseRFQFiles::class, 'rfq_id', 'id');
    }
     public function quotation()
    {
        return $this->hasOne(PurchaseQuotation::class, 'rfq_no', 'rfq_no');
    }
    public function vendor()
{
    return $this->belongsTo(CustomerVendor::class, 'vendor_id', 'id');
}
}
