<?php

namespace App\Models;

use App\Models\Traits\HasAuditFields;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseQuotation extends Model
{
    use HasFactory, SoftDeletes, HasAuditFields;

    protected $fillable = [
        'quotation_no',
        'quotation_date',
        'vendor_name',
        'vendor_id',
        'address',
        'gst',
        'phone',
        'email',
        'rfq_no',
        'rfq_date',
        'additional_charges',
        'vendor_reference_no',
        'delivery_terms',
        'part_no',
        'project_material_no',
        'drawing_no',
        'drawing_rev',
        'quantity',
        'quantity_uom',
        'note',
        'description',
        'sub_total',
        'discount',
        'round_up',
        'grand_total',
        'inr_in_words',
        'status',
        'created_by',
        'updated_by',
        'approved_by',
        'approved_at',
        'rejection_reason',
    ];

    protected $casts = [
        'quotation_date' => 'date',
        'rfq_date' => 'date',
        'approved_at' => 'datetime',
    ];

    // Relationship to items
    public function items()
    {
        return $this->hasMany(PurchaseQuotationItem::class,'purchase_quotation_id');
    }
    
    // Relationship to purchase orders
    public function purchaseOrder()
    {
        return $this->hasOne(PurchaseOrder::class, 'quotation_no', 'quotation_no');
    }

    // Relationship to vendor
    public function vendor()
    {
        return $this->belongsTo(CustomerVendor::class, 'vendor_id');
    }

    // Relationship to RFQ
    public function rfq()
    {
        return $this->belongsTo(Rfq::class, 'rfq_no', 'rfq_no');
    }
    
    public function files()
    {
        return $this->hasMany(PurchaseQuotationFile::class, 'purchase_quotation_id');
    }

}