<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrderItem extends Model
{
    use HasFactory;

    // Fillable fields for itemized product data
    protected $fillable = [
        'purchase_order_id', // FK
        'sl_no',
        'item',
        'description',
        'req_by_date',
        'quantity',
        'uom',
        'unit_rate',
        'tds',
        'discount',
        'value',
        'sgst',
        'cgst',
        'igst',
        'amount'
    ];


    // Relationship back to purchase order
    public function purchaseOrder()
    {
        return $this->belongsTo(PurchaseOrder::class);
    }
    
    public function stockItem()
    {
        return $this->belongsTo(StockItem::class, 'item', 'id'); // 'item' might be foreign key
    }

}
