<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PurchaseItem extends Model
{
    protected $fillable = [
        'purchase_id',
        'stock_item_id',
        'stock_item_name',
        'description',
        'quantity',
        'uom',
        'unit_rate',
        'tds',
        'discount',
        'value',
        'sgst',
        'cgst',
        'igst',
        'amount'
    ];

    public function item()
    {
        return $this->belongsTo(StockItem::class, 'stock_item_id');
    }
}
