<?php

namespace App\Models;

use App\Models\Traits\HasAuditFields;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Purchase extends Model
{
    use SoftDeletes, HasAuditFields;

    protected $table = 'purchases';

    protected $fillable = [
        'purchase_no',
        'purchase_date',
        'purchase_order_no',
        'purchase_order_date',
        'vendor_id',
        'vendor_ref_no',
        'vendor_invoice_no',
        'quotation_no',
        'quotation_date',
        'company_name',
        'company_phone',
        'company_email',
        'company_gstn',
        'company_address',
        'payment_terms',
        'bill_address',
        'ship_address',
        'subtotal',
        'sgst_amount',
        'cgst_amount',
        'igst_amount',
        'additional_charges',
        'tds_amount',
        'net_payable_amount',
        'grand_total',
        'paid_amount',
        'balance_amount',
        'payment_status',
        'inr_in_words',
        'payment_method',
        'payment_reference_no',
        'payment_delay_reason',
        'description',
        'delivery_terms',
        'note',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'purchase_date' => 'date',
        'purchase_order_date' => 'date',
        'quotation_date' => 'date',
    ];

    public function party()
    {
        return $this->belongsTo(CustomerVendor::class, 'vendor_id');
    }

    public function items()
    {
        return $this->hasMany(PurchaseItem::class);
    }
    
    public function files()
    {
        return $this->hasMany(PurchaseFile::class);
    }

    public function purchaseOrder()
    {
        return $this->belongsTo(PurchaseOrder::class, 'purchase_order_no', 'purchase_order_no');
    }

    public function quotation()
    {
        return $this->belongsTo(PurchaseQuotation::class, 'quotation_no', 'quotation_no');
    }

    public function vendor()
    {
        return $this->belongsTo(CustomerVendor::class, 'vendor_id');
    }

    public function creditNotes()
    {
        return $this->hasMany(CreditNote::class, 'invoice_no', 'purchase_no');
    }
}
