<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GrnProductDetail extends Model
{
    protected $fillable = [
        'grn_id', 'sl_no', 'sku_id', 'stock_item_id', 'description', 'quantity', 'unit', 'date', 'supplier', 'remarks'
    ];

    public function skuMaster()
    {
        return $this->belongsTo(SkuMaster::class, 'sku_id');
    }

    public function stockItem()
    {
        return $this->belongsTo(StockItem::class, 'stock_item_id');
    }

    public function grn()
    {
        return $this->belongsTo(Grn::class);
    }
}
