<?php

namespace App\Models;

use App\Models\Traits\HasAuditFields;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CreditNote extends Model
{
    use SoftDeletes, HasAuditFields;

    protected $fillable = [
        'credit_note_no', 'date', 'invoice_no', 'party_id', 'amount', 'reason', 'description',
        'created_by', 'updated_by',
    ];

    protected $casts = [
        'date' => 'date',
        'amount' => 'decimal:2',
    ];

    public function party()
    {
        return $this->belongsTo(CustomerVendor::class, 'party_id');
    }

    public function purchase()
    {
        return $this->belongsTo(Purchase::class, 'invoice_no', 'purchase_no');
    }
}

