<?php

namespace App\Listeners\Sales;

use App\Events\Sales\SalesOrderStatusChanged;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;

class UpdateSalesOrderOnStatusChange implements ShouldQueue
{
    use InteractsWithQueue;

    public function handle(SalesOrderStatusChanged $event): void
    {
        $salesOrder = $event->salesOrder;

        Log::info('Sales Order status changed', [
            'sales_order_id' => $salesOrder->id,
            'previous_status' => $event->previousStatus,
            'new_status' => $event->newStatus,
            'triggered_by' => $event->userId,
        ]);

        // Handle status-specific logic
        switch ($event->newStatus) {
            case 'confirmed':
                // Notify production planning
                break;
            case 'completed':
                // Update related records
                break;
            case 'cancelled':
                // Handle cancellation logic
                break;
        }
    }
}
