<?php

namespace App\Listeners\Sales;

use App\Events\Sales\SalesOrderCreated;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;

class CreateRouteCardForSalesOrder implements ShouldQueue
{
    use InteractsWithQueue;

    public function handle(SalesOrderCreated $event): void
    {
        $salesOrder = $event->salesOrder;

        Log::info('SalesOrderCreated event received', [
            'sales_order_id' => $salesOrder->id,
            'sales_order_no' => $salesOrder->sales_order_no,
            'triggered_by' => $event->userId,
        ]);

        // Route card creation logic can be implemented here
        // This is a placeholder for automatic route card creation
    }

    public function failed(SalesOrderCreated $event, \Throwable $exception): void
    {
        Log::error('Failed to process SalesOrderCreated event', [
            'sales_order_id' => $event->salesOrder->id,
            'error' => $exception->getMessage(),
        ]);
    }
}
