<?php

namespace App\Listeners\Purchase;

use App\Events\Purchase\GrnCreated;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;

class UpdateInventoryOnGrnCreated implements ShouldQueue
{
    use InteractsWithQueue;

    public function handle(GrnCreated $event): void
    {
        $grn = $event->grn;

        Log::info('GRN created event received', [
            'grn_id' => $grn->id,
            'grn_no' => $grn->grn_no,
            'order_no' => $grn->order_no,
            'triggered_by' => $event->userId,
        ]);

        // Update inventory levels based on GRN products
        foreach ($grn->products as $product) {
            // Update raw material stock levels
            // This is a placeholder for actual inventory update logic
            Log::info('Processing GRN product', [
                'material' => $product->material,
                'received_qty' => $product->received_qty,
                'accepted_qty' => $product->accepted_qty,
            ]);
        }
    }
}
