<?php

namespace App\Listeners\Purchase;

use App\Events\Purchase\PurchaseOrderApproved;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class NotifyVendorOnPOApproval implements ShouldQueue
{
    use InteractsWithQueue;

    public function handle(PurchaseOrderApproved $event): void
    {
        $po = $event->purchaseOrder;

        Log::info('Purchase Order approved', [
            'po_id' => $po->id,
            'po_no' => $po->purchase_order_no,
            'vendor_id' => $po->vendor_name,
            'remarks' => $event->remarks,
            'triggered_by' => $event->userId,
        ]);

        // Send notification to vendor
        // This is a placeholder for actual email notification
        if ($po->vendor && $po->vendor->email) {
            // Mail::to($po->vendor->email)->send(new PurchaseOrderApprovedMail($po));
            Log::info('Vendor notification queued', [
                'vendor_email' => $po->vendor->email,
            ]);
        }
    }
}
