<?php

namespace App\Listeners\Inventory;

use App\Events\Inventory\StockLevelLow;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;

class NotifyLowStockLevel implements ShouldQueue
{
    use InteractsWithQueue;

    public function handle(StockLevelLow $event): void
    {
        Log::warning('Low stock level alert', [
            'item_type' => $event->itemType,
            'item_id' => $event->itemId,
            'item_name' => $event->itemName,
            'current_stock' => $event->currentStock,
            'minimum_stock' => $event->minimumStock,
            'reorder_level' => $event->reorderLevel,
            'triggered_by' => $event->userId,
        ]);

        // Send notifications to relevant users
        // This is a placeholder for actual notification logic
        // Notification::send($admins, new LowStockNotification($event));
    }
}
