<?php

namespace App\Http\Resources\Sales;

use App\Http\Resources\BaseResource;
use App\Http\Resources\MasterData\CustomerVendorResource;
use Illuminate\Http\Request;

class SalesOrderResource extends BaseResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'sales_order_no' => $this->sales_order_no,
            'sales_order_date' => $this->formatDate($this->sales_order_date),
            'customer' => new CustomerVendorResource($this->whenLoaded('customer')),
            'customer_id' => $this->customer_name,
            'quotation_no' => $this->quotation_no,
            'quotation_date' => $this->formatDate($this->quotation_date),
            'po_no' => $this->po_no,
            'po_date' => $this->formatDate($this->po_date),
            'part_no' => $this->part_no,
            'project_material_no' => $this->project_material_no,
            'drawing_no' => $this->drawing_no,
            'drawing_rev' => $this->drawing_rev,
            'quantity' => (float) $this->quantity,
            'quantity_uom' => $this->quantity_uom,
            'description' => $this->description,
            'product_type' => $this->product_type,
            'delivery_date' => $this->formatDate($this->delivery_date),
            'note' => $this->note,
            'sub_total' => $this->formatCurrency($this->sub_total),
            'discount' => $this->formatCurrency($this->discount),
            'tax_amount' => $this->formatCurrency($this->tax_amount),
            'grand_total' => $this->formatCurrency($this->grand_total),
            'status' => $this->status,
            'status_badge' => $this->getStatusBadge($this->status ?? 'pending'),
            'has_route_card' => $this->whenLoaded('routeCard', fn() => $this->routeCard !== null),
            'has_invoice' => $this->whenLoaded('invoices', fn() => $this->invoices->isNotEmpty()),
            'created_at' => $this->formatDateTime($this->created_at),
            'updated_at' => $this->formatDateTime($this->updated_at),
        ];
    }
}
