<?php

namespace App\Http\Resources\Sales;

use App\Http\Resources\BaseResource;
use App\Http\Resources\MasterData\CustomerVendorResource;
use Illuminate\Http\Request;

class RfqResource extends BaseResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'rfq_number' => $this->rfq_number,
            'rfq_date' => $this->formatDate($this->rfq_date),
            'customer' => new CustomerVendorResource($this->whenLoaded('customer')),
            'customer_id' => $this->customer_name,
            'part_no' => $this->part_no,
            'project_material_no' => $this->project_material_no,
            'drawing_no' => $this->drawing_no,
            'drawing_rev' => $this->drawing_rev,
            'quantity' => (float) $this->quantity,
            'quantity_uom' => $this->quantity_uom,
            'description' => $this->description,
            'product_type' => $this->product_type,
            'cust_ref_no' => $this->cust_ref_no,
            'note' => $this->note,
            'status' => $this->status,
            'status_badge' => $this->getStatusBadge($this->status ?? 'pending'),
            'has_quotation' => $this->whenLoaded('quotations', fn() => $this->quotations->isNotEmpty()),
            'created_at' => $this->formatDateTime($this->created_at),
            'updated_at' => $this->formatDateTime($this->updated_at),
        ];
    }
}
