<?php

namespace App\Http\Resources\Sales;

use App\Http\Resources\BaseResource;
use App\Http\Resources\MasterData\CustomerVendorResource;
use Illuminate\Http\Request;

class QuotationResource extends BaseResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'quotation_no' => $this->quotation_no,
            'quotation_date' => $this->formatDate($this->quotation_date),
            'customer' => new CustomerVendorResource($this->whenLoaded('customer')),
            'customer_id' => $this->customer_name,
            'rfq_no' => $this->rfq_no,
            'rfq_date' => $this->formatDate($this->rfq_date),
            'part_no' => $this->part_no,
            'project_material_no' => $this->project_material_no,
            'drawing_no' => $this->drawing_no,
            'drawing_rev' => $this->drawing_rev,
            'quantity' => (float) $this->quantity,
            'quantity_uom' => $this->quantity_uom,
            'description' => $this->description,
            'product_type' => $this->product_type,
            'cust_ref_no' => $this->cust_ref_no,
            'note' => $this->note,
            'sub_total' => $this->formatCurrency($this->sub_total),
            'discount' => $this->formatCurrency($this->discount),
            'round_up' => $this->formatCurrency($this->round_up),
            'grand_total' => $this->formatCurrency($this->grand_total),
            'raw_materials' => $this->raw_materials,
            'conversion_costs' => $this->conversion_costs,
            'packing_charges' => $this->packing_charges,
            'is_converted' => $this->whenLoaded('salesOrders', fn() => $this->salesOrders->isNotEmpty()),
            'created_at' => $this->formatDateTime($this->created_at),
            'updated_at' => $this->formatDateTime($this->updated_at),
        ];
    }
}
