<?php

namespace App\Http\Resources\Sales;

use App\Http\Resources\BaseResource;
use App\Http\Resources\MasterData\CustomerVendorResource;
use Illuminate\Http\Request;

class InvoiceResource extends BaseResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'invoice_no' => $this->invoice_no,
            'invoice_date' => $this->formatDate($this->invoice_date),
            'customer' => new CustomerVendorResource($this->whenLoaded('customer')),
            'customer_id' => $this->customer_name,
            'sales_order_no' => $this->sales_order_no,
            'sales_order_date' => $this->formatDate($this->sales_order_date),
            'po_no' => $this->po_no,
            'po_date' => $this->formatDate($this->po_date),
            'challan_no' => $this->challan_no,
            'challan_date' => $this->formatDate($this->challan_date),
            'part_no' => $this->part_no,
            'project_material_no' => $this->project_material_no,
            'drawing_no' => $this->drawing_no,
            'drawing_rev' => $this->drawing_rev,
            'quantity' => (float) $this->quantity,
            'quantity_uom' => $this->quantity_uom,
            'description' => $this->description,
            'product_type' => $this->product_type,
            'note' => $this->note,
            'sub_total' => $this->formatCurrency($this->sub_total),
            'discount' => $this->formatCurrency($this->discount),
            'cgst' => $this->formatCurrency($this->cgst),
            'sgst' => $this->formatCurrency($this->sgst),
            'igst' => $this->formatCurrency($this->igst),
            'round_up' => $this->formatCurrency($this->round_up),
            'grand_total' => $this->formatCurrency($this->grand_total),
            'due_date' => $this->formatDate($this->due_date),
            'paid_amount' => $this->formatCurrency($this->paid_amount ?? 0),
            'balance' => $this->formatCurrency(($this->grand_total ?? 0) - ($this->paid_amount ?? 0)),
            'payment_status' => $this->getPaymentStatus(),
            'status' => $this->status,
            'status_badge' => $this->getStatusBadge($this->status ?? 'pending'),
            'items' => InvoiceItemResource::collection($this->whenLoaded('items')),
            'payments' => $this->whenLoaded('payments'),
            'created_at' => $this->formatDateTime($this->created_at),
            'updated_at' => $this->formatDateTime($this->updated_at),
        ];
    }

    protected function getPaymentStatus(): array
    {
        $total = (float) ($this->grand_total ?? 0);
        $paid = (float) ($this->paid_amount ?? 0);

        if ($paid >= $total) {
            return ['status' => 'paid', 'class' => 'success', 'label' => 'Paid'];
        } elseif ($paid > 0) {
            return ['status' => 'partial', 'class' => 'warning', 'label' => 'Partial'];
        }
        return ['status' => 'unpaid', 'class' => 'danger', 'label' => 'Unpaid'];
    }
}
